/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsDeletionExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.jboss.logging.Logger;

public class OneToManyRowsDeletionExecutor
implements CollectionRowsDeletionExecutor {
    private static final Logger log = Logger.getLogger(OneToManyRowsDeletionExecutor.class);
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final boolean hasIndex;
    private final boolean indexContainsFormula;
    private final boolean deleteByIndex;
    private final Map<Column, JdbcParameter> jdbcParameterMap;
    private final JdbcMutation jdbcMutation;

    public OneToManyRowsDeletionExecutor(PersistentCollectionDescriptor collectionDescriptor, SessionFactoryImplementor sessionFactory, Table dmlTargetTable, boolean hasIndex, boolean indexContainsFormula) {
        this.collectionDescriptor = collectionDescriptor;
        this.hasIndex = hasIndex;
        this.indexContainsFormula = indexContainsFormula;
        this.deleteByIndex = false;
        this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        this.jdbcMutation = this.generateMutation(new TableReference(dmlTargetTable, null, false), this.jdbcParameterMap::put, sessionFactory);
    }

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        Iterator deletes = collection.getDeletes(this.collectionDescriptor, !this.deleteByIndex);
        if (log.isDebugEnabled()) {
            log.debugf("Deleting rows of collection: %s", (Object)MessageHelper.collectionInfoString(this.collectionDescriptor, collection, key, session));
        }
        if (deletes.hasNext()) {
            int passes = 0;
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
            BasicExecutionContext executionContext = new BasicExecutionContext(session);
            while (deletes.hasNext()) {
                Object entry = deletes.next();
                if (this.collectionDescriptor.getIdDescriptor() != null) {
                    this.bindCollectionId(entry, passes, collection, jdbcParameterBindings, session);
                } else {
                    this.bindCollectionKey(key, jdbcParameterBindings, session);
                    if (this.deleteByIndex) {
                        this.bindCollectionIndex(entry, jdbcParameterBindings, session);
                    } else {
                        this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                    }
                }
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.jdbcMutation, jdbcParameterBindings, executionContext);
                jdbcParameterBindings.clear();
                log.debugf("Done deleting collection rows: %s deleted", ++passes);
            }
        } else {
            log.debug((Object)"No rows to delete");
        }
    }

    private JdbcMutation generateMutation(TableReference tableReference, BiConsumer<Column, JdbcParameter> columnCollector, SessionFactoryImplementor sessionFactory) {
        AtomicInteger parameterCount = new AtomicInteger();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        this.applyNavigableLiteralNullAssignment(this.collectionDescriptor.getCollectionKeyDescriptor(), tableReference, assignments, sessionFactory);
        if (this.hasIndex && !this.indexContainsFormula) {
            this.applyNavigableLiteralNullAssignment(this.collectionDescriptor.getIndexDescriptor(), tableReference, assignments, sessionFactory);
        }
        Junction junction = new Junction(Junction.Nature.CONJUNCTION);
        this.collectionDescriptor.getCollectionKeyDescriptor().visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnCollector.accept((Column)column, parameter);
            junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        this.collectionDescriptor.getElementDescriptor().visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnCollector.accept((Column)column, parameter);
            junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        return UpdateToJdbcUpdateConverter.createJdbcUpdate(new UpdateStatement(tableReference, assignments, junction), sessionFactory);
    }

    protected void applyNavigableLiteralNullAssignment(Navigable navigable, TableReference dmlTableRef, List<Assignment> assignments, SessionFactoryImplementor sessionFactory) {
        navigable.visitColumns((sqlExpressableType, column) -> {
            ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
            LiteralParameter parameter = new LiteralParameter(null, column.getExpressableType(), Clause.INSERT, sessionFactory.getTypeConfiguration());
            Assignment assignment = new Assignment(columnReference, parameter);
            assignments.add(assignment);
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
    }

    protected void bindCollectionKey(Object key, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getElementDescriptor().dehydrate(this.collectionDescriptor.getElementDescriptor().unresolve(collection.getElement(entry, this.collectionDescriptor), session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void bindCollectionIndex(Object index, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionIndex indexDescriptor = this.collectionDescriptor.getIndexDescriptor();
        if (indexDescriptor != null) {
            if (indexDescriptor.getBaseIndex() != 0) {
                index = (Integer)index + indexDescriptor.getBaseIndex();
            }
            indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
        }
    }

    protected void bindCollectionId(Object entry, int assumedIdentifier, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        Object identifier = collection.getIdentifier(entry, assumedIdentifier, this.collectionDescriptor);
        this.collectionDescriptor.getIdDescriptor().dehydrate(this.collectionDescriptor.getIdDescriptor().unresolve(identifier, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.DELETE, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

