/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsIndexUpdateExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.LoadParameterBindingContext;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class OneToManyRowsIndexUpdateExecutor
implements CollectionRowsIndexUpdateExecutor {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final Map<Column, JdbcParameter> jdbcParameterMap;
    private final JdbcMutation jdbcMutation;

    public OneToManyRowsIndexUpdateExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        TableReference tableReference = new TableReference(dmlTargetTable, null, false);
        this.jdbcMutation = this.generateUpdateMutation(tableReference, this.jdbcParameterMap::put, sessionFactory);
    }

    @Override
    public void execute(PersistentCollection collection, Object key, boolean queuedOperations, boolean resetIndex, SharedSessionContractImplementor session) {
        Iterator<?> entries = this.resolveEntries(collection, queuedOperations);
        if (entries.hasNext()) {
            int nextIndex;
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
            BasicExecutionContext executionContext = new BasicExecutionContext(session, new LoadParameterBindingContext((SessionFactoryImplementor)session.getSessionFactory(), key));
            int n = nextIndex = resetIndex ? 0 : this.collectionDescriptor.getSize(key, session);
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entry != null && collection.entryExists(entry, nextIndex)) {
                    this.bindCollectionKey(key, jdbcParameterBindings, session);
                    this.bindCollectionId(entry, nextIndex, collection, jdbcParameterBindings, session);
                    this.bindCollectionIndex(entry, nextIndex, collection, jdbcParameterBindings, session);
                    this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                    JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.jdbcMutation, jdbcParameterBindings, executionContext);
                }
                ++nextIndex;
                jdbcParameterBindings.clear();
            }
        }
    }

    private Iterator<?> resolveEntries(PersistentCollection collection, boolean queuedOperations) {
        if (queuedOperations) {
            return collection.queuedAdditionIterator();
        }
        return collection.entries(this.collectionDescriptor);
    }

    private JdbcUpdate generateUpdateMutation(TableReference tableRef, BiConsumer<Column, JdbcParameter> columnCollector, SessionFactoryImplementor sessionFactory) {
        AtomicInteger parameterCount = new AtomicInteger();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        Junction junction = new Junction(Junction.Nature.CONJUNCTION);
        CollectionIndex collectionIndex = this.collectionDescriptor.getIndexDescriptor();
        collectionIndex.visitColumns((sqlExpressableType, column) -> {
            ColumnReference columnReference = tableRef.resolveColumnReference((Column)column);
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnCollector.accept((Column)column, parameter);
            assignments.add(new Assignment(columnReference, parameter));
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            CollectionIdentifier identifier = this.collectionDescriptor.getIdDescriptor();
            identifier.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = tableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        }
        CollectionDomainType.Element element = this.collectionDescriptor.getElementDescriptor();
        EntityValuedNavigable navigable = (EntityValuedNavigable)((Object)element);
        EntityIdentifier identifier = navigable.getEntityDescriptor().getIdentifierDescriptor();
        identifier.visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
            columnCollector.accept((Column)column, parameter);
            junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        return UpdateToJdbcUpdateConverter.createJdbcUpdate(new UpdateStatement(tableRef, assignments, junction), sessionFactory);
    }

    private void bindCollectionKey(Object key, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
    }

    private void bindCollectionId(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private void bindCollectionIndex(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionIndex collectionIndex = this.collectionDescriptor.getIndexDescriptor();
        Object index = collection.getIndex(entry, assumedIndex, this.collectionDescriptor);
        if (collectionIndex.getBaseIndex() != 0) {
            index = (Integer)index + this.collectionDescriptor.getIndexDescriptor().getBaseIndex();
        }
        collectionIndex.dehydrate(collectionIndex.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, Clause.UPDATE), Clause.UPDATE, session);
    }

    private void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        Object element = collection.getElement(entry, this.collectionDescriptor);
        CollectionDomainType.Element collectionElement = this.collectionDescriptor.getElementDescriptor();
        collectionElement.dehydrate(collectionElement.unresolve(element, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, Clause.WHERE), Clause.UPDATE, session);
    }

    void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType sqlExpressableType, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, sqlExpressableType, clause, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

