/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyCreationExecutor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.jboss.logging.Logger;

public class OneToManyRowsInsertExecutor
extends OneToManyCreationExecutor {
    private static final Logger log = Logger.getLogger(OneToManyRowsInsertExecutor.class);

    public OneToManyRowsInsertExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, dmlTargetTable, sessionFactory);
    }

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (key == null) {
            key = collection.getKey();
        }
        assert (key != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        Iterator entries = collection.entries(this.getCollectionDescriptor());
        if (!entries.hasNext()) {
            SqlExecLogger.INSTANCE.debugf("Collection was empty - nothing to (re)create : %s", LoggingHelper.toLoggableString(this.getCollectionDescriptor().getNavigableRole(), collection.getKey()));
            return;
        }
        int passes = 0;
        int count = 0;
        collection.preInsert(this.getCollectionDescriptor());
        while (entries.hasNext()) {
            Object entry = entries.next();
            if (collection.needsInserting(entry, passes)) {
                this.bindCollectionKey(key, jdbcParameterBindings, session);
                this.bindCollectionId(entry, passes, collection, jdbcParameterBindings, session);
                this.bindCollectionIndex(entry, passes, collection, jdbcParameterBindings, session);
                this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                ++count;
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.getCreationOperation(), jdbcParameterBindings, executionContext);
            }
            ++passes;
            jdbcParameterBindings.clear();
        }
        log.debugf("Done inserting rows: %s inserted", count);
    }
}

