/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsUpdateExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class OneToManyRowsUpdateExecutor
implements CollectionRowsUpdateExecutor {
    private List<CollectionRowsUpdateExecutor> executors = new ArrayList<CollectionRowsUpdateExecutor>();

    public OneToManyRowsUpdateExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, boolean rowDeleteEnabled, boolean rowInsertEnabled, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
        this.executors.add(new RowsUpdateDeleteExecutor(collectionDescriptor, dmlTargetTable, rowDeleteEnabled, hasIndex, indexContainsFormula, sessionFactory));
        this.executors.add(new RowsUpdateInsertExecutor(collectionDescriptor, dmlTargetTable, rowInsertEnabled, hasIndex, indexContainsFormula, sessionFactory));
    }

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        for (CollectionRowsUpdateExecutor executor : this.executors) {
            executor.execute(collection, key, session);
        }
    }

    private class RowsUpdateInsertExecutor
    extends AbstractOneToManyRowsUpdateExecutor {
        private final boolean isRowInsertEnabled;

        RowsUpdateInsertExecutor(PersistentCollectionDescriptor persistentCollectionDescriptor, Table dmlTargetTable, boolean rowInsertEnabled, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
            super(persistentCollectionDescriptor, dmlTargetTable, hasIndex, indexContainsFormula, sessionFactory);
            this.isRowInsertEnabled = rowInsertEnabled;
        }

        @Override
        protected boolean isExecutionAllowed() {
            return this.isRowInsertEnabled;
        }

        @Override
        protected JdbcUpdate generateUpdateOperation(TableReference dmlTableRef, BiConsumer<Column, JdbcParameter> columnCollector, SessionFactoryImplementor sessionFactory) {
            AtomicInteger parameterCount = new AtomicInteger();
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            CollectionKey collectionKey = this.getCollectionDescriptor().getCollectionKeyDescriptor();
            collectionKey.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                assignments.add(new Assignment(columnReference, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            if (this.getCollectionDescriptor().getIdDescriptor() != null) {
                throw new NotYetImplementedFor6Exception();
            }
            if (this.getCollectionDescriptor().getIndexDescriptor() != null && this.hasIndex() && !this.indexContainsFormula()) {
                CollectionIndex collectionIndex = this.getCollectionDescriptor().getIndexDescriptor();
                collectionIndex.visitColumns((sqlExpressableType, column) -> {
                    ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                    PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                    columnCollector.accept((Column)column, parameter);
                    assignments.add(new Assignment(columnReference, parameter));
                }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            }
            Junction junction = new Junction(Junction.Nature.CONJUNCTION);
            CollectionDomainType.Element collectionElement = this.getCollectionDescriptor().getElementDescriptor();
            collectionElement.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            return UpdateToJdbcUpdateConverter.createJdbcUpdate(new UpdateStatement(dmlTableRef, assignments, junction), sessionFactory);
        }
    }

    private class RowsUpdateDeleteExecutor
    extends AbstractOneToManyRowsUpdateExecutor {
        private final boolean isRowDeleteEnabled;

        RowsUpdateDeleteExecutor(PersistentCollectionDescriptor persistentCollectionDescriptor, Table dmlTargetTable, boolean rowDeleteEnabled, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
            super(persistentCollectionDescriptor, dmlTargetTable, hasIndex, indexContainsFormula, sessionFactory);
            this.isRowDeleteEnabled = rowDeleteEnabled;
        }

        @Override
        protected boolean isExecutionAllowed() {
            return this.isRowDeleteEnabled;
        }

        @Override
        protected JdbcUpdate generateUpdateOperation(TableReference dmlTableRef, BiConsumer<Column, JdbcParameter> columnCollector, SessionFactoryImplementor sessionFactory) {
            AtomicInteger parameterCount = new AtomicInteger();
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            CollectionKey collectionKey = this.getCollectionDescriptor().getCollectionKeyDescriptor();
            collectionKey.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                LiteralParameter parameter = new LiteralParameter(null, column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                assignments.add(new Assignment(columnReference, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            if (this.getCollectionDescriptor().getIndexDescriptor() != null && this.hasIndex() && !this.indexContainsFormula()) {
                CollectionIndex collectionIndex = this.getCollectionDescriptor().getIndexDescriptor();
                collectionIndex.visitColumns((sqlExpressableType, column) -> {
                    ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                    LiteralParameter parameter = new LiteralParameter(null, column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                    assignments.add(new Assignment(columnReference, parameter));
                }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            }
            Junction junction = new Junction(Junction.Nature.CONJUNCTION);
            collectionKey.visitColumns((sqlExpressableType, column) -> {
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            CollectionDomainType.Element collectionElement = this.getCollectionDescriptor().getElementDescriptor();
            collectionElement.visitColumns((sqlExpressableType, column) -> {
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
            return UpdateToJdbcUpdateConverter.createJdbcUpdate(new UpdateStatement(dmlTableRef, assignments, junction), sessionFactory);
        }

        @Override
        protected void bindCollectionIndex(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
        }

        @Override
        protected void bindCollectionElement(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
            Object element = collection.getSnapshotElement(entry, assumedIndex);
            this.getCollectionDescriptor().getElementDescriptor().dehydrate(this.getCollectionDescriptor().getElementDescriptor().unresolve(element, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, clause), clause, session);
        }
    }

    private abstract class AbstractOneToManyRowsUpdateExecutor
    implements CollectionRowsUpdateExecutor {
        private final PersistentCollectionDescriptor collectionDescriptor;
        private final boolean hasIndex;
        private final boolean indexContainsFormula;
        private final Map<Column, JdbcParameter> jdbcParameterMap;
        private final JdbcUpdate jdbcUpdate;

        AbstractOneToManyRowsUpdateExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
            this.collectionDescriptor = collectionDescriptor;
            this.hasIndex = hasIndex;
            this.indexContainsFormula = indexContainsFormula;
            this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
            TableReference tableReference = new TableReference(dmlTargetTable, null, false);
            this.jdbcUpdate = this.generateUpdateOperation(tableReference, this.jdbcParameterMap::put, sessionFactory);
        }

        @Override
        public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
            if (this.isExecutionAllowed()) {
                JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
                BasicExecutionContext executionContext = new BasicExecutionContext(session);
                int i = 0;
                Iterator entries = collection.entries(this.getCollectionDescriptor());
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.needsUpdating(entry, i)) {
                        this.bindCollectionKey(key, jdbcParameterBindings, session, Clause.UPDATE);
                        this.bindCollectionIndex(entry, i, collection, jdbcParameterBindings, session, Clause.UPDATE);
                        this.bindCollectionElement(entry, i, collection, jdbcParameterBindings, session, Clause.UPDATE);
                        JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.jdbcUpdate, jdbcParameterBindings, executionContext);
                        jdbcParameterBindings.clear();
                    }
                    ++i;
                }
            }
        }

        protected PersistentCollectionDescriptor getCollectionDescriptor() {
            return this.collectionDescriptor;
        }

        protected boolean hasIndex() {
            return this.hasIndex;
        }

        protected boolean indexContainsFormula() {
            return this.indexContainsFormula;
        }

        protected abstract boolean isExecutionAllowed();

        protected abstract JdbcUpdate generateUpdateOperation(TableReference var1, BiConsumer<Column, JdbcParameter> var2, SessionFactoryImplementor var3);

        protected void bindCollectionKey(Object key, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
            this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, clause), clause, session);
        }

        protected void bindCollectionIndex(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
            CollectionIndex indexDescriptor = this.collectionDescriptor.getIndexDescriptor();
            if (indexDescriptor != null) {
                Object index = collection.getIndex(entry, assumedIndex, this.collectionDescriptor);
                if (indexDescriptor.getBaseIndex() != 0) {
                    index = (Integer)index + indexDescriptor.getBaseIndex();
                }
                indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, clause), clause, session);
            }
        }

        protected void bindCollectionElement(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
            Object element = collection.getElement(entry, this.collectionDescriptor);
            this.getCollectionDescriptor().getElementDescriptor().dehydrate(this.getCollectionDescriptor().getElementDescriptor().unresolve(element, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, clause), clause, session);
        }

        void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType sqlExpressableType, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
            JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
            jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, sqlExpressableType, clause, session.getFactory().getTypeConfiguration()));
        }

        private JdbcParameter resolveJdbcParameter(Column boundColumn) {
            JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
            if (jdbcParameter == null) {
                throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
            }
            return jdbcParameter;
        }
    }
}

