/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.spi.FromClauseAccess;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;

public class SqlAstHelper {
    public static DomainResult generateCollectionElementDomainResult(NavigablePath elementPath, CollectionElement elementDescriptor, boolean isSelected, String resultVariable, DomainResultCreationState creationState) {
        assert (elementDescriptor != null);
        assert (elementPath != null);
        assert (elementPath.getParent() != null);
        assert (elementPath.getLocalName().equals("{element}"));
        FromClauseAccess fromClauseAccess = creationState.getFromClauseAccess();
        fromClauseAccess.resolveTableGroup(elementPath, np -> fromClauseAccess.getTableGroup(elementPath.getParent()));
        return elementDescriptor.createDomainResult(elementPath, resultVariable, creationState);
    }

    public static DomainResult generateCollectionIndexDomainResult(NavigablePath indexPath, CollectionIndex indexDescriptor, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        assert (indexDescriptor != null);
        assert (indexPath != null);
        assert (indexPath.getParent() != null);
        assert (indexPath.getLocalName().equals("{index}"));
        FromClauseAccess fromClauseAccess = creationState.getFromClauseAccess();
        fromClauseAccess.resolveTableGroup(indexPath, np -> fromClauseAccess.getTableGroup(indexPath.getParent()));
        return indexDescriptor.createDomainResult(indexPath, resultVariable, creationState);
    }
}

