/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.AbstractManagedType;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.InheritanceCapable;
import org.hibernate.metamodel.model.domain.spi.Instantiator;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.SqmPathRegistry;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.java.internal.EmbeddableJavaDescriptorImpl;
import org.hibernate.type.descriptor.java.internal.EmbeddedMutabilityPlanImpl;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddedTypeDescriptorImpl<J>
extends AbstractManagedType<J>
implements EmbeddedTypeDescriptor<J> {
    private final EmbeddedContainer container;
    private final NavigableRole navigableRole;
    private ManagedTypeRepresentationStrategy representationStrategy;
    private Instantiator<J> instantiator;
    private boolean fullyInitialized;
    private List<Column> collectedColumns;

    public EmbeddedTypeDescriptorImpl(EmbeddedValueMappingImplementor embeddedMapping, EmbeddedContainer container, EmbeddedTypeDescriptor superTypeDescriptor, String localName, SingularPersistentAttribute.Disposition compositeDisposition, RuntimeModelCreationContext creationContext) {
        super(embeddedMapping, superTypeDescriptor, EmbeddedTypeDescriptorImpl.resolveJtd(creationContext, embeddedMapping), creationContext);
        EmbeddableJavaDescriptorImpl javaTypeDescriptor = (EmbeddableJavaDescriptorImpl)embeddedMapping.getJavaTypeMapping().getJavaTypeDescriptor();
        javaTypeDescriptor.setMutabilityPlan(new EmbeddedMutabilityPlanImpl(this));
        this.container = container;
        this.navigableRole = container.getNavigableRole().append(localName);
    }

    private static <T> EmbeddableJavaDescriptor<T> resolveJtd(RuntimeModelCreationContext creationContext, EmbeddedValueMappingImplementor embeddedMapping) {
        JavaTypeDescriptorRegistry jtdr = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        EmbeddableJavaDescriptorImpl jtd = (EmbeddableJavaDescriptorImpl)jtdr.getDescriptor(embeddedMapping.getName());
        if (jtd == null) {
            Class javaType = StringHelper.isEmpty(embeddedMapping.getEmbeddableClassName()) ? null : creationContext.getSessionFactory().getServiceRegistry().getService(ClassLoaderService.class).classForName(embeddedMapping.getEmbeddableClassName());
            jtd = new EmbeddableJavaDescriptorImpl(embeddedMapping.getName(), javaType, null);
            jtdr.addDescriptor(jtd);
        }
        return jtd;
    }

    @Override
    public boolean finishInitialization(ManagedTypeMappingImplementor bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (!this.fullyInitialized) {
            try {
                boolean done = this.tryFinishInitialization(bootDescriptor, creationContext);
                if (!done) {
                    return false;
                }
                this.fullyInitialized = true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return true;
    }

    private boolean tryFinishInitialization(ManagedTypeMappingImplementor bootDescriptor, RuntimeModelCreationContext creationContext) {
        boolean superDone = super.finishInitialization(bootDescriptor, creationContext);
        if (!superDone) {
            return false;
        }
        this.representationStrategy = creationContext.getMetadata().getMetadataBuildingOptions().getManagedTypeRepresentationResolver().resolveStrategy(bootDescriptor, this, creationContext);
        this.instantiator = this.representationStrategy.resolveInstantiator(bootDescriptor, this, creationContext.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider());
        return true;
    }

    @Override
    public EmbeddedContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor() {
        return this;
    }

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor() {
        return (EmbeddableJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public J instantiate(SharedSessionContractImplementor session) {
        return this.instantiator.instantiate(session);
    }

    @Override
    public boolean isDirty(Object one, Object another, SharedSessionContractImplementor session) {
        if (one == another) {
            return false;
        }
        for (NonIdPersistentAttribute attribute : this.getPersistentAttributes()) {
            Object anotherValue;
            Object oneValue;
            if (!attribute.isDirty(oneValue = attribute.getPropertyAccess().getGetter().get(one), anotherValue = attribute.getPropertyAccess().getGetter().get(another), session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        for (NonIdPersistentAttribute attribute : this.getPersistentAttributes()) {
            Object anotherValue;
            Object oneValue;
            if (attribute.areEqual(oneValue = attribute.getPropertyAccess().getGetter().get(x), anotherValue = attribute.getPropertyAccess().getGetter().get(y))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int extractHashCode(Object value) {
        int result = 17;
        for (NonIdPersistentAttribute attribute : this.getPersistentAttributes()) {
            Object oneValue = attribute.getPropertyAccess().getGetter().get(value);
            result *= 37;
            if (oneValue == null) continue;
            result += attribute.extractHashCode(oneValue);
        }
        return result;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.makeSubGraph(this.getJavaType());
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        return new SubGraphImpl(this, true, this.getTypeConfiguration().getSessionFactory());
    }

    @Override
    public <S extends J> ManagedTypeDescriptor<S> findSubType(String subTypeName) {
        return null;
    }

    @Override
    public <S extends J> ManagedTypeDescriptor<S> findSubType(Class<S> type) {
        return null;
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getNavigableName());
        SqmPathRegistry pathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
        return (SqmNavigableReference)pathRegistry.resolvePath(navigablePath, np -> new SqmEmbeddedValuedSimplePath(navigablePath, this, lhs));
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Column> collectColumns() {
        if (this.collectedColumns == null) {
            this.collectedColumns = new ArrayList<Column>();
            this.visitAttributes(persistentAttribute -> this.collectedColumns.addAll(persistentAttribute.getColumns()));
        }
        return this.collectedColumns;
    }

    @Override
    public int getNumberOfJdbcParametersNeeded() {
        return this.collectColumns().size();
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.visitStateArrayContributors(contributor -> contributor.visitJdbcTypes(action, clause, typeConfiguration));
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.visitStateArrayContributors(contributor -> contributor.visitColumns(action, clause, typeConfiguration));
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        assert (value instanceof Object[]);
        Object[] subValues = (Object[])value;
        this.visitStateArrayContributors(stateArrayContributor -> stateArrayContributor.dehydrate(subValues[stateArrayContributor.getStateArrayPosition()], jdbcValueCollector, clause, session));
    }

    @Override
    public List<InheritanceCapable<? extends J>> getSubclassTypes() {
        return Collections.emptyList();
    }

    @Override
    public void setPropertyValue(Object object, int i, Object value) {
        this.getPersistentAttributes().get(i).getPropertyAccess().getSetter().set(object, value, this.getTypeConfiguration().getSessionFactory());
    }

    @Override
    public Object getPropertyValue(Object object, int i) throws HibernateException {
        return this.getPersistentAttributes().get(i).getPropertyAccess().getGetter().get(object);
    }

    @Override
    public Object getPropertyValue(Object object, String propertyName) {
        NonIdPersistentAttribute attribute = this.findPersistentAttribute(propertyName);
        if (attribute == null) {
            throw new HibernateException("No persistent attribute named [" + propertyName + "] on embeddable [" + this.getRoleName() + ']');
        }
        return attribute.getPropertyAccess().getGetter().get(object);
    }

    @Override
    public CascadeStyle getCascadeStyle(int i) {
        return this.getPersistentAttributes().get(i).getCascadeStyle();
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        Object[] values = this.getPropertyValues(value);
        this.visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            values[index] = contributor.unresolve(values[index], session);
        });
        return values;
    }

    public String toString() {
        return this.getNavigableRole().getFullPath();
    }
}

