/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import javax.persistence.metamodel.Type;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorMappings;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.BasicType;

public class DiscriminatorDescriptorImpl<O, J>
implements DiscriminatorDescriptor<J> {
    public static final String NAVIGABLE_NAME = "{discriminator}";
    private final EntityHierarchy hierarchy;
    private final BasicType basicType;
    private final BasicValueMapper<J> valueMapper;
    private final Column column;
    private final NavigableRole navigableRole;

    public DiscriminatorDescriptorImpl(EntityHierarchy hierarchy, BasicValueMapping<J> valueMapping, RuntimeModelCreationContext creationContext) {
        this.hierarchy = hierarchy;
        this.basicType = valueMapping.getResolution().getBasicType();
        this.valueMapper = valueMapping.getResolution().getValueMapper();
        this.column = creationContext.getDatabaseObjectResolver().resolveColumn(valueMapping.getMappedColumn());
        this.navigableRole = hierarchy.getRootEntityType().getNavigableRole().append(NAVIGABLE_NAME);
    }

    @Override
    public EntityTypeDescriptor<O> getContainer() {
        return this.hierarchy.getRootEntityType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getNavigableName() {
        return NAVIGABLE_NAME;
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getValueMapper().getDomainJavaDescriptor();
    }

    @Override
    public DiscriminatorMappings getDiscriminatorMappings() {
        throw new NotYetImplementedException();
    }

    @Override
    public String asLoggableText() {
        return this.getContainer().asLoggableText() + '.' + NAVIGABLE_NAME;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.valueMapper.getSqlExpressableType();
    }
}

