/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class DiscriminatorDomainResult
implements DomainResult {
    private final DiscriminatorDescriptor discriminatorDescriptor;
    private final String resultVariable;
    private final SqlSelection sqlSelection;
    private final NavigablePath navigablePath;

    public <J, O> DiscriminatorDomainResult(DiscriminatorDescriptor discriminatorDescriptor, SqlSelection sqlSelection, NavigablePath navigablePath, String resultVariable) {
        this.discriminatorDescriptor = discriminatorDescriptor;
        this.sqlSelection = sqlSelection;
        this.navigablePath = navigablePath;
        this.resultVariable = resultVariable;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public BasicJavaDescriptor<?> getJavaTypeDescriptor() {
        return this.discriminatorDescriptor.getJavaTypeDescriptor();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public DomainResultAssembler createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
        return new DomainResultAssemblerImpl(this.discriminatorDescriptor, this.sqlSelection);
    }

    private static class DomainResultAssemblerImpl
    implements DomainResultAssembler {
        private final DiscriminatorDescriptor discriminatorDescriptor;
        private final SqlSelection sqlSelection;

        public DomainResultAssemblerImpl(DiscriminatorDescriptor discriminatorDescriptor, SqlSelection sqlSelection) {
            this.discriminatorDescriptor = discriminatorDescriptor;
            this.sqlSelection = sqlSelection;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Object jdbcValue = rowProcessingState.getJdbcValue(this.sqlSelection);
            String entityName = this.discriminatorDescriptor.getDiscriminatorMappings().discriminatorValueToEntityName(jdbcValue);
            EntityTypeDescriptor entityDescriptor = rowProcessingState.getSession().getFactory().getMetamodel().findEntityDescriptor(entityName);
            return entityDescriptor.getJavaType();
        }

        @Override
        public BasicJavaDescriptor<?> getJavaTypeDescriptor() {
            return this.discriminatorDescriptor.getJavaTypeDescriptor();
        }
    }
}

