/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.entity.DiscriminatorDescriptorImpl;
import org.hibernate.metamodel.model.domain.internal.entity.EntityIdentifierCompositeAggregatedImpl;
import org.hibernate.metamodel.model.domain.internal.entity.EntityIdentifierCompositeNonAggregatedImpl;
import org.hibernate.metamodel.model.domain.internal.entity.EntityIdentifierSimpleImpl;
import org.hibernate.metamodel.model.domain.internal.entity.NaturalIdDescriptorImpl;
import org.hibernate.metamodel.model.domain.internal.entity.RowIdDescriptorImpl;
import org.hibernate.metamodel.model.domain.internal.entity.VersionDescriptorImpl;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.InheritanceStrategy;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.RowIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.type.descriptor.java.spi.EntityMutabilityPlan;
import org.jboss.logging.Logger;

public class EntityHierarchyImpl
implements EntityHierarchy {
    private static final Logger log = Logger.getLogger(EntityHierarchyImpl.class);
    private final EntityTypeDescriptor<?> rootEntityDescriptor;
    private final InheritanceStrategy inheritanceStrategy;
    private final OptimisticLockStyle optimisticLockStyle;
    private final RepresentationMode representationMode;
    private final EntityIdentifier identifierDescriptor;
    private final DiscriminatorDescriptor discriminatorDescriptor;
    private final VersionDescriptor versionDescriptor;
    private final NaturalIdDescriptor naturalIdentifierDescriptor;
    private final RowIdDescriptor rowIdDescriptor;
    private final TenantDiscrimination tenantDiscrimination;
    private EntityDataAccess caching;
    private SqmMutationStrategy sqmMutationStrategy;
    private final EntityMutabilityPlan mutabilityPlan;
    private final boolean implicitPolymorphismEnabled;
    private final String whereFragment;

    public EntityHierarchyImpl(EntityTypeDescriptor rootRuntimeDescriptor, RootClass rootBootDescriptor, RuntimeModelCreationContext creationContext) {
        log.debugf("Creating EntityHierarchy root EntityPersister : %s", (Object)rootRuntimeDescriptor);
        this.rootEntityDescriptor = rootRuntimeDescriptor;
        this.inheritanceStrategy = EntityHierarchyImpl.interpretInheritanceType(rootBootDescriptor);
        this.identifierDescriptor = EntityHierarchyImpl.interpretIdentifierDescriptor(this, rootBootDescriptor, rootRuntimeDescriptor, creationContext);
        this.discriminatorDescriptor = EntityHierarchyImpl.interpretDiscriminatorDescriptor(this, rootBootDescriptor, creationContext);
        this.versionDescriptor = EntityHierarchyImpl.interpretVersionDescriptor(this, rootBootDescriptor, creationContext);
        this.rowIdDescriptor = EntityHierarchyImpl.interpretRowIdDescriptor(this, rootBootDescriptor, creationContext);
        this.tenantDiscrimination = EntityHierarchyImpl.interpretTenantDiscrimination(this, rootBootDescriptor, creationContext);
        this.naturalIdentifierDescriptor = EntityHierarchyImpl.interpretNaturalIdentifierDescriptor(this, rootBootDescriptor, creationContext);
        this.representationMode = EntityHierarchyImpl.determineRepresentationMode(rootBootDescriptor, rootRuntimeDescriptor, creationContext);
        this.implicitPolymorphismEnabled = !rootBootDescriptor.isExplicitPolymorphism();
        this.optimisticLockStyle = rootBootDescriptor.getEntityMappingHierarchy().getOptimisticLockStyle();
        this.mutabilityPlan = (EntityMutabilityPlan)rootBootDescriptor.getJavaTypeMapping().getJavaTypeDescriptor().getMutabilityPlan();
        this.whereFragment = rootBootDescriptor.getWhere();
    }

    private static RepresentationMode determineRepresentationMode(RootClass rootEntityBinding, EntityTypeDescriptor rootEntityDescriptor, RuntimeModelCreationContext creationContext) {
        if (rootEntityBinding.getExplicitRepresentationMode() != null) {
            return rootEntityBinding.getExplicitRepresentationMode();
        }
        if (rootEntityDescriptor.getJavaTypeDescriptor().getJavaType() == null) {
            return RepresentationMode.MAP;
        }
        return RepresentationMode.POJO;
    }

    private static InheritanceStrategy interpretInheritanceType(RootClass rootEntityBinding) {
        if (rootEntityBinding.getSubTypeMappings().isEmpty()) {
            return InheritanceStrategy.NONE;
        }
        Subclass subEntityBinding = (Subclass)rootEntityBinding.getSubTypeMappings().iterator().next();
        if (subEntityBinding instanceof UnionSubclass) {
            return InheritanceStrategy.UNION;
        }
        if (subEntityBinding instanceof JoinedSubclass) {
            return InheritanceStrategy.JOINED;
        }
        return InheritanceStrategy.DISCRIMINATOR;
    }

    private static EntityIdentifier interpretIdentifierDescriptor(EntityHierarchyImpl runtimeModelHierarchy, RootClass bootModelRootEntity, EntityTypeDescriptor runtimeModelRootEntity, RuntimeModelCreationContext creationContext) {
        if (bootModelRootEntity.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() != null) {
            return new EntityIdentifierCompositeNonAggregatedImpl(runtimeModelHierarchy, ((EmbeddedValueMappingImplementor)((Object)bootModelRootEntity.getIdentifier())).makeRuntimeDescriptor(runtimeModelRootEntity, bootModelRootEntity.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping().getName(), SingularPersistentAttribute.Disposition.ID, creationContext), bootModelRootEntity.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping());
        }
        if (bootModelRootEntity.getIdentifier() instanceof EmbeddedValueMappingImplementor) {
            assert (!bootModelRootEntity.getIdentifierAttributeMapping().isOptional());
            return new EntityIdentifierCompositeAggregatedImpl(runtimeModelHierarchy, bootModelRootEntity, ((EmbeddedValueMappingImplementor)((Object)bootModelRootEntity.getIdentifier())).makeRuntimeDescriptor(runtimeModelHierarchy.getRootEntityType(), bootModelRootEntity.getIdentifierAttributeMapping().getName(), SingularPersistentAttribute.Disposition.ID, creationContext), creationContext);
        }
        assert (!bootModelRootEntity.getIdentifierAttributeMapping().isOptional());
        return new EntityIdentifierSimpleImpl(runtimeModelHierarchy, bootModelRootEntity, creationContext);
    }

    private static RowIdDescriptor interpretRowIdDescriptor(EntityHierarchyImpl hierarchy, RootClass rootEntityBinding, RuntimeModelCreationContext creationContext) {
        if (rootEntityBinding.getRootTable().getRowId() != null) {
            return new RowIdDescriptorImpl(hierarchy, creationContext);
        }
        return null;
    }

    private static DiscriminatorDescriptor interpretDiscriminatorDescriptor(EntityHierarchyImpl hierarchy, RootClass rootEntityBinding, RuntimeModelCreationContext creationContext) {
        creationContext.getDatabaseObjectResolver().resolveTable(rootEntityBinding.getRootTable());
        if (rootEntityBinding.getDiscriminator() == null) {
            return null;
        }
        return new DiscriminatorDescriptorImpl(hierarchy, (BasicValueMapping)((Object)rootEntityBinding.getDiscriminator()), creationContext);
    }

    private static VersionDescriptor interpretVersionDescriptor(EntityHierarchyImpl hierarchy, RootClass rootEntityBinding, RuntimeModelCreationContext creationContext) {
        if (rootEntityBinding.getVersionAttributeMapping() == null) {
            return null;
        }
        return new VersionDescriptorImpl(hierarchy, rootEntityBinding, creationContext);
    }

    private static TenantDiscrimination interpretTenantDiscrimination(EntityHierarchyImpl hierarchy, RootClass rootEntityBinding, RuntimeModelCreationContext creationContext) {
        return null;
    }

    private static NaturalIdDescriptor interpretNaturalIdentifierDescriptor(EntityHierarchyImpl entityHierarchy, RootClass rootEntityMapping, RuntimeModelCreationContext creationContext) {
        if (!rootEntityMapping.hasNaturalId()) {
            return null;
        }
        return new NaturalIdDescriptorImpl(entityHierarchy, entityHierarchy.getRootEntityType().getFactory().getCache().getNaturalIdCacheRegionAccessStrategy(entityHierarchy.rootEntityDescriptor.getNavigableRole()));
    }

    @Override
    public void finishInitialization(RuntimeModelCreationContext creationContext, RootClass mappingType) {
        if (mappingType.hasNaturalId()) {
            ArrayList attributes = new ArrayList();
            for (Property property : mappingType.getDeclaredProperties()) {
                if (!property.isNaturalIdentifier()) continue;
                NonIdPersistentAttribute runtimeAttribute = this.rootEntityDescriptor.findPersistentAttribute(property.getName());
                if (!SingularPersistentAttribute.class.isInstance(runtimeAttribute)) {
                    throw new HibernateException("Attempt to define non-singular attribute [" + property.getName() + "] as part of the entity's natural-id : " + this.rootEntityDescriptor.getEntityName());
                }
                attributes.add(runtimeAttribute);
            }
            ((NaturalIdDescriptorImpl)this.naturalIdentifierDescriptor).injectAttributes(attributes);
        }
        this.sqmMutationStrategy = SqmMutationStrategyHelper.resolveStrategy(mappingType.getEntityMappingHierarchy(), this, creationContext.getSessionFactory().getSessionFactoryOptions(), creationContext.getSessionFactory().getServiceRegistry());
    }

    @Override
    public void visitConstraintOrderedTables(BiConsumer<Table, List<Column>> tableConsumer) {
        this.visitConstraintOrderedTables(this.rootEntityDescriptor, tableConsumer);
    }

    private void visitConstraintOrderedTables(IdentifiableTypeDescriptor<?> typeDescriptor, BiConsumer<Table, List<Column>> tableConsumer) {
        typeDescriptor.visitSubTypeDescriptors(subTypeDescriptor -> this.visitConstraintOrderedTables((IdentifiableTypeDescriptor<?>)subTypeDescriptor, tableConsumer));
        typeDescriptor.visitConstraintOrderedTables(tableConsumer);
    }

    public EntityTypeDescriptor getRootEntityType() {
        return this.rootEntityDescriptor;
    }

    @Override
    public RepresentationMode getRepresentation() {
        return this.representationMode;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    public EntityIdentifier getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    public DiscriminatorDescriptor getDiscriminatorDescriptor() {
        return this.discriminatorDescriptor;
    }

    public VersionDescriptor getVersionDescriptor() {
        return this.versionDescriptor;
    }

    @Override
    public NaturalIdDescriptor getNaturalIdDescriptor() {
        return this.naturalIdentifierDescriptor;
    }

    public RowIdDescriptor getRowIdDescriptor() {
        return this.rowIdDescriptor;
    }

    @Override
    public TenantDiscrimination getTenantDiscrimination() {
        return this.tenantDiscrimination;
    }

    @Override
    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    @Override
    public EntityDataAccess getEntityCacheAccess() {
        if (this.caching == null) {
            this.caching = this.rootEntityDescriptor.getFactory().getCache().getEntityRegionAccess(this.rootEntityDescriptor.getNavigableRole());
        }
        return this.caching;
    }

    @Override
    public SqmMutationStrategy getSqmMutationStrategy() {
        return this.sqmMutationStrategy;
    }

    @Override
    public EntityMutabilityPlan getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public boolean isImplicitPolymorphismEnabled() {
        return this.implicitPolymorphismEnabled;
    }

    @Override
    public String getWhere() {
        return this.whereFragment;
    }
}

