/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Type;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.ValueMapping;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.entity.EntityHierarchyImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierCompositeAggregated;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EntityIdentifierCompositeAggregatedImpl<O, J>
extends AbstractSingularPersistentAttribute<O, J>
implements EntityIdentifierCompositeAggregated<O, J> {
    private final EmbeddedTypeDescriptor<J> embeddedDescriptor;
    private final IdentifierGenerator identifierGenerator;
    private final List<Column> columns;
    private final IdentifierValue unsavedValue;

    public EntityIdentifierCompositeAggregatedImpl(EntityHierarchyImpl runtimeModelHierarchy, RootClass bootModelRootEntity, EmbeddedTypeDescriptor embeddedDescriptor, RuntimeModelCreationContext creationContext) {
        super(runtimeModelHierarchy.getRootEntityType(), bootModelRootEntity.getIdentifierProperty(), embeddedDescriptor.getRepresentationStrategy().generatePropertyAccess(bootModelRootEntity, bootModelRootEntity.getIdentifierProperty(), (ManagedTypeDescriptor)embeddedDescriptor.getContainer(), creationContext.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider()), SingularPersistentAttribute.Disposition.ID);
        this.embeddedDescriptor = embeddedDescriptor;
        this.identifierGenerator = creationContext.getSessionFactory().getIdentifierGenerator(bootModelRootEntity.getEntityName());
        ValueMapping valueMapping = bootModelRootEntity.getIdentifierAttributeMapping().getValueMapping();
        this.columns = valueMapping.getMappedColumns().stream().map(creationContext.getDatabaseObjectResolver()::resolveColumn).collect(Collectors.toList());
        this.unsavedValue = UnsavedValueFactory.getUnsavedIdentifierValue(bootModelRootEntity.getIdentifier().getNullValue(), this.getPropertyAccess().getGetter(), embeddedDescriptor.getJavaTypeDescriptor(), EntityIdentifierCompositeAggregatedImpl.getConstructor(bootModelRootEntity));
    }

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor() {
        return this.embeddedDescriptor;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getEmbeddedDescriptor().getNavigableRole();
    }

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getEmbeddedDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public int getNumberOfJdbcParametersForRestriction() {
        return this.getEmbeddedDescriptor().getNumberOfJdbcParametersForRestriction();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEmbeddedDescriptor().visitFetchables(fetchableConsumer);
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.EMBEDDED;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public SingularPersistentAttribute.SingularAttributeClassification getAttributeTypeClassification() {
        return SingularPersistentAttribute.SingularAttributeClassification.EMBEDDED;
    }

    @Override
    public String asLoggableText() {
        return "IdentifierCompositeAggregated(" + this.embeddedDescriptor.asLoggableText() + ")";
    }

    @Override
    public SimpleTypeDescriptor<J> getNavigableType() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public boolean hasSingleIdAttribute() {
        return true;
    }

    @Override
    public SingularPersistentAttribute asAttribute(Class javaType) {
        return this;
    }

    @Override
    public IdentifierGenerator getIdentifierValueGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEmbeddedDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getEmbeddedDescriptor().visitNavigables(visitor);
    }

    public boolean isOptional() {
        return false;
    }

    @Override
    public int getNumberOfJdbcParametersNeeded() {
        return this.getColumns().size();
    }

    @Override
    public boolean canContainSubGraphs() {
        return false;
    }

    @Override
    public IdentifierValue getUnsavedValue() {
        return this.unsavedValue;
    }

    @Override
    public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        if (hydratedForm == null) {
            return null;
        }
        Object[] hydratedState = (Object[])hydratedForm;
        Object[] state = new Object[this.getEmbeddedDescriptor().getStateArrayContributors().size()];
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            state[index] = contributor.resolveHydratedState(hydratedState[index], executionContext, session, containerInstance);
        });
        J result = this.getEmbeddedDescriptor().instantiate(session);
        this.getEmbeddedDescriptor().setPropertyValues(result, state);
        return result;
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        Object[] values = this.getEmbeddedDescriptor().getPropertyValues(value);
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            values[index] = contributor.unresolve(values[index], session);
        });
        return values;
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        AtomicInteger position = new AtomicInteger();
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> contributor.dehydrate(values[position.getAndIncrement()], jdbcValueCollector, clause, session));
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getColumns().forEach(column -> action.accept(column.getExpressableType(), (Column)column));
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getNavigableName());
        return new SqmEmbeddedValuedSimplePath(navigablePath, this, lhs);
    }

    @Override
    public EmbeddedTypeDescriptor<J> getType() {
        return this.getAttributeType();
    }

    @Override
    public EmbeddedTypeDescriptor<J> getAttributeType() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public EmbeddedTypeDescriptor<?> getValueGraphType() {
        return this.getAttributeType();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return null;
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || persistentClass.getExplicitRepresentationMode() != RepresentationMode.POJO) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public boolean areEqual(J x, J y) throws HibernateException {
        return this.getEmbeddedDescriptor().areEqual(x, y);
    }

    @Override
    public int extractHashCode(J o) {
        return this.getEmbeddedDescriptor().extractHashCode(o);
    }
}

