/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Type;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.entity.EntityHierarchyImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.BasicTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.BasicValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierSimple;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EntityIdentifierSimpleImpl<O, J>
extends AbstractSingularPersistentAttribute<O, J>
implements EntityIdentifierSimple<O, J>,
BasicValuedNavigable<J> {
    private final String name;
    private final Column column;
    private final BasicValueMapper<J> valueMapper;
    private final IdentifierGenerator identifierGenerator;
    private final IdentifierValue unsavedValue;

    public EntityIdentifierSimpleImpl(EntityHierarchyImpl runtimeModelHierarchy, RootClass bootModelRootEntity, RuntimeModelCreationContext creationContext) {
        super(runtimeModelHierarchy.getRootEntityType(), bootModelRootEntity.getIdentifierAttributeMapping(), runtimeModelHierarchy.getRootEntityType().getRepresentationStrategy().generatePropertyAccess(bootModelRootEntity, bootModelRootEntity.getIdentifierAttributeMapping(), runtimeModelHierarchy.getRootEntityType(), creationContext.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider()), SingularPersistentAttribute.Disposition.ID);
        this.name = bootModelRootEntity.getIdentifierAttributeMapping().getName();
        BasicValueMapping basicValueMapping = (BasicValueMapping)bootModelRootEntity.getIdentifierAttributeMapping().getValueMapping();
        this.column = creationContext.getDatabaseObjectResolver().resolveColumn(basicValueMapping.getMappedColumn());
        this.valueMapper = basicValueMapping.getResolution().getValueMapper();
        this.identifierGenerator = creationContext.getSessionFactory().getIdentifierGenerator(bootModelRootEntity.getEntityName());
        this.unsavedValue = UnsavedValueFactory.getUnsavedIdentifierValue(bootModelRootEntity.getIdentifier().getNullValue(), this.getPropertyAccess().getGetter(), basicValueMapping.getJavaTypeMapping().getJavaTypeDescriptor(), EntityIdentifierSimpleImpl.getConstructor(bootModelRootEntity));
    }

    @Override
    public BasicTypeDescriptor<J> getNavigableType() {
        return this;
    }

    @Override
    public BasicTypeDescriptor<J> getAttributeType() {
        return (BasicTypeDescriptor)super.getAttributeType();
    }

    @Override
    public boolean hasSingleIdAttribute() {
        return true;
    }

    @Override
    public List<Column> getColumns() {
        return Collections.singletonList(this.column);
    }

    @Override
    public IdentifierValue getUnsavedValue() {
        return this.unsavedValue;
    }

    @Override
    public SingularPersistentAttribute asAttribute(Class javaType) {
        return this;
    }

    @Override
    public IdentifierGenerator getIdentifierValueGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.valueMapper.getSqlExpressableType();
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return (BasicJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public BasicTypeDescriptor<J> getType() {
        return this.getAttributeType();
    }

    @Override
    public SingularPersistentAttribute.SingularAttributeClassification getAttributeTypeClassification() {
        return SingularPersistentAttribute.SingularAttributeClassification.BASIC;
    }

    @Override
    public String asLoggableText() {
        return "IdentifierSimple(" + this.getContainer().asLoggableText() + ")";
    }

    @Override
    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.BASIC;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        visitor.visitSimpleIdentifier(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BasicTypeDescriptor<?> getValueGraphType() {
        return this.getAttributeType();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return null;
    }

    public boolean isOptional() {
        return false;
    }

    @Override
    public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        return hydratedForm;
    }

    public void visitJdbcTypes(Consumer action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.getBoundColumn().getExpressableType());
    }

    @Override
    public void visitColumns(BiConsumer action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.getBoundColumn().getExpressableType(), this.getBoundColumn());
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || persistentClass.getExplicitRepresentationMode() != RepresentationMode.POJO) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

