/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Type;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class NaturalIdDescriptorImpl<J>
implements NaturalIdDescriptor<J>,
AllowableParameterType<J> {
    private final EntityHierarchy hierarchy;
    private final NaturalIdDataAccess cacheRegionAccess;
    private final NavigableRole navigableRole;
    private List<NaturalIdDescriptor.NaturalIdAttributeInfo> attributes;
    private Integer numberOfParameterBinds;

    public NaturalIdDescriptorImpl(EntityHierarchy hierarchy, NaturalIdDataAccess cacheRegionAccess) {
        this.hierarchy = hierarchy;
        this.cacheRegionAccess = cacheRegionAccess;
        this.navigableRole = hierarchy.getRootEntityType().getNavigableRole().append("naturalId");
    }

    public void injectAttributes(List<NonIdPersistentAttribute<?, ?>> attributes) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<NaturalIdDescriptor.NaturalIdAttributeInfo>();
            this.numberOfParameterBinds = 0;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            this.attributes.add(new NaturalIdAttributeInfoImpl(attributes.get(i), i));
            NaturalIdDescriptorImpl naturalIdDescriptorImpl = this;
            Integer.valueOf(naturalIdDescriptorImpl.numberOfParameterBinds + ((AllowableParameterType)((Object)attributes.get(i))).getNumberOfJdbcParametersNeeded());
            naturalIdDescriptorImpl.numberOfParameterBinds = naturalIdDescriptorImpl.numberOfParameterBinds;
        }
    }

    @Override
    public List<NaturalIdDescriptor.NaturalIdAttributeInfo> getAttributeInfos() {
        return this.attributes;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object[] resolveSnapshot(Object entityId, SharedSessionContractImplementor session) {
        return new Object[0];
    }

    @Override
    public NaturalIdDataAccess getCacheAccess() {
        return this.cacheRegionAccess;
    }

    @Override
    public NavigableContainer getContainer() {
        return this.hierarchy.getRootEntityType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        this.attributes.forEach(attributeInfo -> attributeInfo.getUnderlyingAttributeDescriptor().visitNavigable(visitor));
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationContext) {
        ArrayList<ColumnReference> columnRefs = new ArrayList<ColumnReference>();
        this.attributes.forEach(attributeInfo -> columnRefs.addAll(attributeInfo.getUnderlyingAttributeDescriptor().resolveColumnReferences(qualifier, creationContext)));
        return columnRefs;
    }

    @Override
    public String asLoggableText() {
        return "NaturalId (" + this.hierarchy.getRootEntityType().getEntityName() + ")";
    }

    @Override
    public JavaTypeDescriptor<J> getJavaTypeDescriptor() {
        return this.hierarchy.getRootEntityType().getJavaTypeDescriptor();
    }

    public Type.PersistenceType getPersistenceType() {
        return this.attributes.size() > 1 ? Type.PersistenceType.EMBEDDABLE : Type.PersistenceType.BASIC;
    }

    @Override
    public int getNumberOfJdbcParametersNeeded() {
        return this.numberOfParameterBinds;
    }

    public AllowableParameterType resolveTemporalPrecision(TemporalType temporalType, TypeConfiguration typeConfiguration) {
        NaturalIdDescriptor.NaturalIdAttributeInfo naturalIdAttributeInfo;
        if (this.attributes.size() == 1 && (naturalIdAttributeInfo = this.attributes.get(0)).getUnderlyingAttributeDescriptor() instanceof TemporalJavaDescriptor) {
            TemporalJavaDescriptor jtd = (TemporalJavaDescriptor)naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor();
            return (AllowableParameterType)((Object)jtd.resolveTypeForPrecision(temporalType, typeConfiguration));
        }
        throw new UnsupportedOperationException("Composite natural-id cannot be treated as a temporal value");
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.visitPersistentAttributes(naturalIdAttributeInfo -> naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().visitColumns(action, clause, typeConfiguration));
    }

    public static class NaturalIdAttributeInfoImpl
    implements NaturalIdDescriptor.NaturalIdAttributeInfo {
        private final NonIdPersistentAttribute underlyingAttribute;
        private final int stateArrayPosition;

        public NaturalIdAttributeInfoImpl(NonIdPersistentAttribute underlyingAttribute, int stateArrayPosition) {
            this.underlyingAttribute = underlyingAttribute;
            this.stateArrayPosition = stateArrayPosition;
        }

        @Override
        public NonIdPersistentAttribute getUnderlyingAttributeDescriptor() {
            return this.underlyingAttribute;
        }

        @Override
        public int getStateArrayPosition() {
            return this.stateArrayPosition;
        }
    }
}

