/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.boot.model.domain.spi.EntityMappingImplementor;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.ValueInclusion;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.loader.internal.TemplateParameterBindingContext;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.spi.AbstractEntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.JoinedTableBinding;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.InsertToJdbcInsertConverter;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.produce.internal.SqlAstDeleteDescriptorImpl;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class SingleTableEntityTypeDescriptor<T>
extends AbstractEntityTypeDescriptor<T> {
    private Boolean hasCollections;
    private final boolean isJpaCacheComplianceEnabled;
    private final boolean lifecycleImplementor;

    public SingleTableEntityTypeDescriptor(EntityMappingImplementor bootMapping, IdentifiableTypeDescriptor<? super T> superTypeDescriptor, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(bootMapping, superTypeDescriptor, creationContext);
        this.isJpaCacheComplianceEnabled = creationContext.getSessionFactory().getSessionFactoryOptions().getJpaCompliance().isJpaCacheComplianceEnabled();
        this.lifecycleImplementor = this.getRepresentationStrategy().getMode() == RepresentationMode.MAP ? false : Lifecycle.class.isAssignableFrom(bootMapping.getMappedClass());
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        if (this.getHierarchy().getDiscriminatorDescriptor() == null) {
            throw new UnsupportedOperationException("Entity [" + this.getEntityName() + "] is not inherited");
        }
        return new SqmBasicValuedSimplePath(new NavigablePath(this.getNavigableName() + "{type}"), this.getHierarchy().getDiscriminatorDescriptor(), null);
    }

    @Override
    public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationState) {
        return this.getIdentifierDescriptor().resolveColumnReferences(qualifier, creationState);
    }

    @Override
    public String asLoggableText() {
        return String.format("SingleTableEntityDescriptor<%s>", this.getEntityName());
    }

    @Override
    public int[] findDirty(Object[] currentState, Object[] previousState, Object owner, SharedSessionContractImplementor session) {
        ArrayList results = new ArrayList();
        this.visitStateArrayContributors(contributor -> {
            boolean dirty;
            int index = contributor.getStateArrayPosition();
            boolean bl = dirty = currentState[index] != LazyPropertyInitializer.UNFETCHED_PROPERTY && (previousState[index] == LazyPropertyInitializer.UNFETCHED_PROPERTY || contributor.isIncludedInDirtyChecking() && contributor.isDirty(previousState[index], currentState[index], session));
            if (dirty) {
                results.add(index);
            }
        });
        if (results.size() == 0) {
            return null;
        }
        return results.stream().mapToInt(i -> i).toArray();
    }

    @Override
    public int[] findModified(Object[] old, Object[] current, Object object, SharedSessionContractImplementor session) {
        return new int[0];
    }

    @Override
    public void lock(Object id, Object version, Object object, LockMode lockMode, SharedSessionContractImplementor session) throws HibernateException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    protected Object insertInternal(Object id, Object[] fields, Object object, SharedSessionContractImplementor session) {
        IdentifierGenerator generator;
        if (id == null && (generator = this.getHierarchy().getIdentifierDescriptor().getIdentifierValueGenerator()) != null) {
            id = generator.generate(session, object);
        }
        Object unresolvedId = id;
        ExecutionContext executionContext = this.getExecutionContext(session);
        this.executeInsert(fields, session, unresolvedId, executionContext, new TableReference(this.getPrimaryTable(), null, false));
        this.getSecondaryTableBindings().forEach(tableBindings -> this.executeJoinTableInsert(fields, session, unresolvedId, executionContext, (JoinedTableBinding)tableBindings));
        return id;
    }

    private void executeJoinTableInsert(Object[] fields, SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext, JoinedTableBinding tableBindings) {
        if (tableBindings.isInverse()) {
            return;
        }
        TableReference tableReference = new TableReference(tableBindings.getReferringTable(), null, tableBindings.isOptional());
        ValuesNullChecker jdbcValuesToInsert = new ValuesNullChecker();
        InsertStatement insertStatement = new InsertStatement(tableReference);
        this.visitStateArrayContributors(contributor -> {
            int position = contributor.getStateArrayPosition();
            Object domainValue = fields[position];
            contributor.dehydrate(contributor.getJavaTypeDescriptor().isInstance(domainValue) ? contributor.unresolve(domainValue, session) : domainValue, (jdbcValue, type, boundColumn) -> {
                if (boundColumn.getSourceTable().equals(tableReference.getTable()) && jdbcValue != null) {
                    jdbcValuesToInsert.setNotAllNull();
                    this.addInsertColumn(session, insertStatement, jdbcValue, boundColumn, type);
                }
            }, Clause.INSERT, session);
        });
        if (jdbcValuesToInsert.areAllNull()) {
            return;
        }
        this.getHierarchy().getIdentifierDescriptor().dehydrate(this.getHierarchy().getIdentifierDescriptor().unresolve(unresolvedId, session), (jdbcValue, type, boundColumn) -> {
            Column referringColumn = tableBindings.getJoinForeignKey().getColumnMappings().findReferringColumn(boundColumn);
            this.addInsertColumn(session, insertStatement, jdbcValue, referringColumn, boundColumn.getExpressableType());
        }, Clause.INSERT, session);
        TenantDiscrimination tenantDiscrimination = this.getHierarchy().getTenantDiscrimination();
        if (tenantDiscrimination != null) {
            this.addInsertColumn(session, insertStatement, tenantDiscrimination.unresolve(session.getTenantIdentifier(), session), tenantDiscrimination.getBoundColumn(), tenantDiscrimination.getBoundColumn().getExpressableType());
        }
        this.executeInsert(executionContext, insertStatement);
    }

    private void executeInsert(Object[] fields, SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext, TableReference tableReference) {
        TenantDiscrimination tenantDiscrimination;
        InsertStatement insertStatement = new InsertStatement(tableReference);
        this.getHierarchy().getIdentifierDescriptor().dehydrate(this.getHierarchy().getIdentifierDescriptor().unresolve(unresolvedId, session), (jdbcValue, type, boundColumn) -> {
            insertStatement.addTargetColumnReference(new ColumnReference(boundColumn));
            insertStatement.addValue(new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.INSERT, session.getFactory().getTypeConfiguration()));
        }, Clause.INSERT, session);
        DiscriminatorDescriptor discriminatorDescriptor = this.getHierarchy().getDiscriminatorDescriptor();
        if (discriminatorDescriptor != null) {
            this.addInsertColumn(session, insertStatement, discriminatorDescriptor.unresolve(this.getDiscriminatorValue(), session), discriminatorDescriptor.getBoundColumn(), discriminatorDescriptor.getBoundColumn().getExpressableType());
        }
        if ((tenantDiscrimination = this.getHierarchy().getTenantDiscrimination()) != null) {
            this.addInsertColumn(session, insertStatement, tenantDiscrimination.unresolve(session.getTenantIdentifier(), session), tenantDiscrimination.getBoundColumn(), tenantDiscrimination.getBoundColumn().getExpressableType());
        }
        this.visitStateArrayContributors(contributor -> {
            int position = contributor.getStateArrayPosition();
            Object domainValue = fields[position];
            contributor.dehydrate(contributor.getJavaTypeDescriptor().isInstance(domainValue) ? contributor.unresolve(domainValue, session) : domainValue, (jdbcValue, type, boundColumn) -> {
                if (boundColumn.getSourceTable().equals(tableReference.getTable())) {
                    this.addInsertColumn(session, insertStatement, jdbcValue, boundColumn, type);
                }
            }, Clause.INSERT, session);
        });
        this.executeInsert(executionContext, insertStatement);
    }

    private void executeInsert(ExecutionContext executionContext, InsertStatement insertStatement) {
        JdbcInsert jdbcInsert = InsertToJdbcInsertConverter.createJdbcInsert(insertStatement, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        this.executeOperation(jdbcInsert, (rows, prepareStatement) -> {}, executionContext);
    }

    private void addInsertColumn(SharedSessionContractImplementor session, InsertStatement insertStatement, Object jdbcValue, Column referringColumn, SqlExpressableType expressableType) {
        if (jdbcValue != null) {
            insertStatement.addTargetColumnReference(new ColumnReference(referringColumn));
            insertStatement.addValue(new LiteralParameter(jdbcValue, expressableType, Clause.INSERT, session.getFactory().getTypeConfiguration()));
        }
    }

    @Override
    public void delete(Object id, Object version, Object object, SharedSessionContractImplementor session) throws HibernateException {
        Object unresolvedId = this.getHierarchy().getIdentifierDescriptor().unresolve(id, session);
        ExecutionContext executionContext = this.getExecutionContext(session);
        this.delete(unresolvedId, executionContext, session);
    }

    private void delete(Object unresolvedId, ExecutionContext executionContext, SharedSessionContractImplementor session) {
        this.deleteSecondaryTables(session, unresolvedId, executionContext);
        this.deleteRootTable(session, unresolvedId, executionContext);
    }

    private void deleteRootTable(SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext) {
        TableReference tableReference = new TableReference(this.getPrimaryTable(), null, false);
        Junction identifierJunction = new Junction(Junction.Nature.CONJUNCTION);
        this.getHierarchy().getIdentifierDescriptor().dehydrate(unresolvedId, (jdbcValue, type, boundColumn) -> identifierJunction.add(new ComparisonPredicate(new ColumnReference(boundColumn), ComparisonOperator.EQUAL, new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.DELETE, session.getFactory().getTypeConfiguration()))), Clause.DELETE, session);
        this.executeDelete(executionContext, tableReference, identifierJunction);
    }

    private void deleteSecondaryTables(SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext) {
        this.getSecondaryTableBindings().forEach(secondaryTable -> {
            TableReference secondaryTableReference = new TableReference(secondaryTable.getReferringTable(), null, secondaryTable.isOptional());
            Junction identifierJunction = new Junction(Junction.Nature.CONJUNCTION);
            this.getHierarchy().getIdentifierDescriptor().dehydrate(unresolvedId, (jdbcValue, type, boundColumn) -> {
                Column referringColumn = secondaryTable.getJoinForeignKey().getColumnMappings().findReferringColumn(boundColumn);
                identifierJunction.add(new ComparisonPredicate(new ColumnReference(referringColumn), ComparisonOperator.EQUAL, new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.DELETE, session.getFactory().getTypeConfiguration())));
            }, Clause.DELETE, session);
            this.executeDelete(executionContext, secondaryTableReference, identifierJunction);
        });
    }

    private void executeDelete(ExecutionContext executionContext, TableReference tableReference, Junction identifierJunction) {
        DeleteStatement deleteStatement = new DeleteStatement(tableReference, identifierJunction);
        JdbcDelete delete = SqlDeleteToJdbcDeleteConverter.interpret(new SqlAstDeleteDescriptorImpl(deleteStatement, Collections.singleton(deleteStatement.getTargetTable().getTable().getTableExpression())), (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        this.executeOperation(delete, (rows, prepareStatement) -> {}, executionContext);
    }

    @Override
    public void update(Object id, Object[] fields, int[] dirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SharedSessionContractImplementor session) throws HibernateException {
        boolean isRowToInsert;
        EntityEntry entry = session.getPersistenceContext().getEntry(object);
        if (entry == null && !this.getJavaTypeDescriptor().getMutabilityPlan().isMutable()) {
            throw new IllegalStateException("Updating immutable entity that is not in session yet!");
        }
        Object unresolvedId = this.getHierarchy().getIdentifierDescriptor().unresolve(id, session);
        ExecutionContext executionContext = this.getExecutionContext(session);
        Table primaryTable = this.getPrimaryTable();
        TableReference tableReference = new TableReference(primaryTable, null, false);
        if (this.isTableNeedUpdate(tableReference, dirtyFields, hasDirtyCollection, true) && (isRowToInsert = this.updateInternal(fields, dirtyFields, oldFields, session, unresolvedId, executionContext, tableReference, Expectations.appropriateExpectation(this.rootUpdateResultCheckStyle))) && isRowToInsert) {
            this.executeInsert(fields, session, unresolvedId, executionContext, tableReference);
        }
        this.getSecondaryTableBindings().forEach(secondaryTable -> {
            boolean isRowToInsert;
            TableReference secondaryTableReference = new TableReference(secondaryTable.getReferringTable(), null, secondaryTable.isOptional());
            if (!secondaryTable.isInverse() && this.isTableNeedUpdate(secondaryTableReference, dirtyFields, hasDirtyCollection, false) && (isRowToInsert = this.updateInternal(fields, dirtyFields, oldFields, session, unresolvedId, executionContext, secondaryTableReference, Expectations.appropriateExpectation(secondaryTable.getUpdateResultCheckStyle())))) {
                this.executeJoinTableInsert(fields, session, unresolvedId, executionContext, (JoinedTableBinding)secondaryTable);
            }
        });
    }

    private boolean updateInternal(Object[] fields, int[] dirtyFields, Object[] oldFields, SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext, TableReference tableReference, Expectation expectation) {
        boolean isRowToUpdate;
        boolean isNullableTable = this.isNullableTable(tableReference);
        boolean isFieldsAllNull = this.isAllNull(fields, tableReference.getTable());
        if (isNullableTable && oldFields != null && this.isAllNull(oldFields, tableReference.getTable())) {
            isRowToUpdate = false;
        } else if (isNullableTable && isFieldsAllNull) {
            isRowToUpdate = true;
            this.delete(unresolvedId, executionContext, session);
        } else {
            RowToUpdateChecker checker = new RowToUpdateChecker(unresolvedId, isNullableTable, expectation, this.getFactory(), this);
            this.executeUpdate(fields, oldFields, session, unresolvedId, executionContext, tableReference, checker);
            isRowToUpdate = checker.isRowToUpdate();
        }
        return !isRowToUpdate && !isFieldsAllNull;
    }

    private boolean isFieldValueChanged(Object[] fields, Object[] oldFields, int position) {
        if (oldFields == null) {
            return true;
        }
        Object oldField = oldFields[position];
        Object field = fields[position];
        if (field == null && oldField == null) {
            return false;
        }
        if (field != null) {
            return !field.equals(oldField);
        }
        return !oldField.equals(field);
    }

    private int executeUpdate(Object[] fields, Object[] oldFields, SharedSessionContractImplementor session, Object unresolvedId, ExecutionContext executionContext, TableReference tableReference, RowToUpdateChecker checker) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        boolean anyFieldToUpdate = false;
        for (int i = 0; i < fields.length; ++i) {
            StateArrayContributor<?> contributor = this.getStateArrayContributors().get(i);
            Object domainValue = fields[contributor.getStateArrayPosition()];
            List<Column> columns = contributor.getColumns();
            if (!contributor.isUpdatable() || columns == null || columns.isEmpty() || !this.isFieldValueChanged(fields, oldFields, i)) continue;
            anyFieldToUpdate = true;
            contributor.dehydrate(contributor.unresolve(domainValue, session), (jdbcValue, type, boundColumn) -> {
                if (boundColumn.getSourceTable().equals(tableReference.getTable())) {
                    assignments.add(new Assignment(new ColumnReference(boundColumn), new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.UPDATE, session.getFactory().getTypeConfiguration())));
                }
            }, Clause.UPDATE, session);
        }
        if (anyFieldToUpdate) {
            Junction identifierJunction = new Junction(Junction.Nature.CONJUNCTION);
            this.getHierarchy().getIdentifierDescriptor().dehydrate(unresolvedId, (jdbcValue, type, boundColumn) -> identifierJunction.add(new ComparisonPredicate(new ColumnReference(boundColumn), ComparisonOperator.EQUAL, new LiteralParameter(jdbcValue, boundColumn.getExpressableType(), Clause.WHERE, session.getFactory().getTypeConfiguration()))), Clause.WHERE, session);
            UpdateStatement updateStatement = new UpdateStatement(tableReference, assignments, identifierJunction);
            return this.executeUpdate(updateStatement, checker, executionContext);
        }
        return 0;
    }

    private int executeUpdate(UpdateStatement updateStatement, RowToUpdateChecker checker, ExecutionContext executionContext) {
        JdbcUpdate jdbcUpdate = UpdateToJdbcUpdateConverter.createJdbcUpdate(updateStatement, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        return this.executeOperation(jdbcUpdate, (rows, prepareStatement) -> checker.check((Integer)rows, (PreparedStatement)prepareStatement), executionContext);
    }

    private int executeOperation(JdbcMutation operation, BiConsumer<Integer, PreparedStatement> checker, ExecutionContext executionContext) {
        JdbcMutationExecutor executor = JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL;
        return executor.execute(operation, JdbcParameterBindings.NO_BINDINGS, executionContext, (rows, preparestatement) -> checker.accept((Integer)rows, (PreparedStatement)preparestatement));
    }

    protected final boolean isAllNull(Object[] fields, Table table) {
        List<StateArrayContributor<?>> stateArrayContributors = this.getStateArrayContributors();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            List<Column> columns = stateArrayContributors.get(i).getColumns();
            for (Column column : columns) {
                if (!column.getSourceTable().equals(table)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isTableNeedUpdate(TableReference tableReference, int[] dirtyProperties, boolean hasDirtyCollection, boolean isRootTable) {
        if (dirtyProperties == null) {
            for (Column column : tableReference.getTable().getColumns()) {
                if (!column.isUpdatable()) continue;
                return true;
            }
            return false;
        }
        boolean tableNeedUpdate = false;
        List<StateArrayContributor<?>> stateArrayContributors = this.getStateArrayContributors();
        for (int property : dirtyProperties) {
            StateArrayContributor<?> contributor = stateArrayContributors.get(property);
            List<Column> columns = contributor.getColumns();
            for (Column column : columns) {
                if (!column.getSourceTable().equals(tableReference.getTable()) || !contributor.isUpdatable()) continue;
                tableNeedUpdate = true;
            }
        }
        if (isRootTable && this.getHierarchy().getVersionDescriptor() != null) {
            tableNeedUpdate = tableNeedUpdate || Versioning.isVersionIncrementRequired(dirtyProperties, hasDirtyCollection, this.getPropertyVersionability());
        }
        return tableNeedUpdate;
    }

    private boolean isNullableTable(TableReference tableReference) {
        return tableReference.isOptional() || this.isJpaCacheComplianceEnabled;
    }

    private ExecutionContext getExecutionContext(final SharedSessionContractImplementor session) {
        return new ExecutionContext(){
            private final DomainParameterBindingContext parameterBindingContext;
            {
                this.parameterBindingContext = new TemplateParameterBindingContext(session.getFactory());
            }

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsImpl();
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return this.parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        };
    }

    @Override
    public ValueInclusion[] getPropertyInsertGenerationInclusions() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public ValueInclusion[] getPropertyUpdateGenerationInclusions() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean[] getPropertyUpdateability() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean[] getPropertyVersionability() {
        boolean[] propertyVersionability = new boolean[this.getStateArrayContributors().size()];
        this.visitStateArrayContributors(contributor -> {
            int position = contributor.getStateArrayPosition();
            propertyVersionability[position] = contributor.isIncludedInOptimisticLocking();
        });
        return propertyVersionability;
    }

    @Override
    public boolean[] getPropertyLaziness() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public CascadeStyle[] getPropertyCascadeStyles() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean hasCascades() {
        for (StateArrayContributor<?> contributor : this.getStateArrayContributors()) {
            CascadeStyle cascadeStyle = contributor.getCascadeStyle();
            if (CascadeStyles.NONE == cascadeStyle) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getIdentifierPropertyName() {
        return this.getHierarchy().getIdentifierDescriptor().getNavigableName();
    }

    @Override
    public boolean isCacheInvalidationRequired() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean isLazyPropertiesCacheable() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public CacheEntry buildCacheEntry(Object entity, Object[] state, Object version, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Serializable getIdByUniqueKey(Serializable key, String uniquePropertyName, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object getCurrentVersion(Object id, SharedSessionContractImplementor session) throws HibernateException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object forceVersionIncrement(Object id, Object currentVersion, SharedSessionContractImplementor session) throws HibernateException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean isInstrumented() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Boolean isTransient(Object object, SharedSessionContractImplementor session) throws HibernateException {
        Object id = this.getHierarchy().getIdentifierDescriptor().extractIdentifier(object);
        if (id == null) {
            return Boolean.TRUE;
        }
        Object version = this.getVersion(object);
        if (this.getHierarchy().getVersionDescriptor() != null) {
            return this.getHierarchy().getVersionDescriptor().getUnsavedValue() == version;
        }
        Boolean result = this.getHierarchy().getIdentifierDescriptor().getUnsavedValue().isUnsaved(id);
        if (result != null) {
            return result;
        }
        if (session.getCacheMode().isGetEnabled() && this.canReadFromCache()) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        return null;
    }

    @Override
    public Object[] getPropertyValuesToInsert(Object object, Map mergeMap, SharedSessionContractImplementor session) throws HibernateException {
        Object[] stateArray = new Object[this.getStateArrayContributors().size()];
        this.visitStateArrayContributors(contributor -> {
            stateArray[contributor.getStateArrayPosition()] = contributor.getPropertyAccess().getGetter().getForInsert(object, mergeMap, session);
        });
        return stateArray;
    }

    @Override
    public void processInsertGeneratedProperties(Object id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void processUpdateGeneratedProperties(Object id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Class getMappedClass() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    @Override
    public boolean implementsLifecycle() {
        return this.lifecycleImplementor;
    }

    @Override
    public EntityTypeDescriptor getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory) {
        if (this.getSubclassTypes().isEmpty()) {
            return this;
        }
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int[] resolveAttributeIndexes(String[] attributeNames) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean canUseReferenceCacheEntries() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerAffectingFetchProfile(String fetchProfileName) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean hasCollections() {
        if (this.hasCollections == null) {
            this.hasCollections = false;
            this.controlledVisitAttributes(attr -> {
                if (attr instanceof PluralPersistentAttribute) {
                    this.hasCollections = true;
                    return false;
                }
                if (attr instanceof SingularPersistentAttributeEmbedded) {
                    ((SingularPersistentAttributeEmbedded)attr).getEmbeddedDescriptor().controlledVisitAttributes(embeddedAttribute -> {
                        if (embeddedAttribute instanceof PluralPersistentAttribute) {
                            this.hasCollections = true;
                            return false;
                        }
                        return true;
                    });
                }
                return true;
            });
        }
        return this.hasCollections;
    }

    private class ValuesNullChecker {
        private boolean allNull = true;

        private ValuesNullChecker() {
        }

        private void setNotAllNull() {
            this.allNull = false;
        }

        public boolean areAllNull() {
            return this.allNull;
        }
    }

    private static class RowToUpdateChecker {
        private final Object id;
        private final boolean isNullableTable;
        private final Expectation expectation;
        private final SessionFactoryImplementor factory;
        private final EntityTypeDescriptor entityDescriptor;
        private boolean isRowToUpdate;

        public RowToUpdateChecker(Object id, boolean isNullableTable, Expectation expectation, SessionFactoryImplementor factory, EntityTypeDescriptor entityDescriptor) {
            this.id = id;
            this.isNullableTable = isNullableTable;
            this.expectation = expectation;
            this.factory = factory;
            this.entityDescriptor = entityDescriptor;
        }

        public void check(Integer rows, PreparedStatement preparedStatement) {
            try {
                this.expectation.verifyOutcome(rows, preparedStatement, -1);
            }
            catch (StaleStateException e) {
                if (this.isNullableTable) {
                    if (this.factory.getStatistics().isStatisticsEnabled()) {
                        this.factory.getStatistics().optimisticFailure(this.entityDescriptor.getEntityName());
                    }
                    throw new StaleObjectStateException(this.entityDescriptor.getEntityName(), this.id);
                }
                this.isRowToUpdate = false;
            }
            catch (TooManyRowsAffectedException e) {
                throw new HibernateException("Duplicate identifier in table for: " + MessageHelper.infoString(this.entityDescriptor, this.id, this.factory));
            }
            catch (Throwable t) {
                this.isRowToUpdate = false;
            }
            this.isRowToUpdate = true;
        }

        public boolean isRowToUpdate() {
            return this.isRowToUpdate;
        }
    }
}

