/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.AbstractTableReferenceCollector;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class ToOneJoinCollectorImpl
extends AbstractTableReferenceCollector {
    private final NavigablePath navigablePath;
    private final SingularPersistentAttributeEntity attribute;
    private final TableGroup lhs;
    private final String explicitSourceAlias;
    private final LockMode lockMode;
    private Predicate predicate;

    public ToOneJoinCollectorImpl(NavigablePath navigablePath, SingularPersistentAttributeEntity attribute, TableGroup lhs, String explicitSourceAlias, LockMode lockMode) {
        this.navigablePath = navigablePath;
        this.attribute = attribute;
        this.lhs = lhs;
        this.explicitSourceAlias = explicitSourceAlias;
        this.lockMode = lockMode;
    }

    @Override
    public void addPrimaryReference(TableReference primaryTableReference) {
        if (this.getPrimaryTableReference() == null) {
            super.addPrimaryReference(primaryTableReference);
            return;
        }
        if (this.lhs != null) {
            this.addSecondaryReference(this.makeJoin(this.lhs, primaryTableReference));
        }
    }

    private TableReferenceJoin makeJoin(ColumnReferenceQualifier lhs, TableReference rootTableReference) {
        return new TableReferenceJoin(JoinType.LEFT, rootTableReference, this.makePredicate(lhs, rootTableReference));
    }

    private Predicate makePredicate(ColumnReferenceQualifier lhs, TableReference rhs) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : this.attribute.getForeignKey().getColumnMappings().getColumnMappings()) {
            ColumnReference referringColumnReference = lhs.resolveColumnReference(columnMapping.getReferringColumn());
            ColumnReference targetColumnReference = rhs.resolveColumnReference(columnMapping.getTargetColumn());
            conjunction.add(new ComparisonPredicate(referringColumnReference, ComparisonOperator.EQUAL, targetColumnReference));
        }
        return conjunction;
    }

    public TableGroupJoin generateTableGroup(JoinType joinType) {
        StandardTableGroup joinedTableGroup = new StandardTableGroup(this.navigablePath, this.attribute, this.lockMode, this.getPrimaryTableReference(), this.getTableReferenceJoins(), this.lhs);
        Predicate predicate = null;
        if (this.lhs != null) {
            predicate = this.makePredicate(this.lhs, this.getPrimaryTableReference());
        }
        return new TableGroupJoin(joinType, joinedTableGroup, predicate);
    }
}

