/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.entity;

import javax.persistence.metamodel.Attribute;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.internal.entity.EntityHierarchyImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractNonIdSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.results.internal.domain.basic.BasicFetch;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class VersionDescriptorImpl<O, J>
extends AbstractNonIdSingularPersistentAttribute<O, J>
implements VersionDescriptor<O, J>,
BasicValuedExpressableType<J> {
    private final Column column;
    private final BasicValueMapper<J> valueMapper;
    private final VersionSupport<J> versionSupport;
    private final String unsavedValue;

    public VersionDescriptorImpl(EntityHierarchyImpl runtimeModelHierarchy, RootClass bootModelRootEntity, RuntimeModelCreationContext creationContext) {
        super(runtimeModelHierarchy.getRootEntityType(), bootModelRootEntity.getVersionAttributeMapping(), runtimeModelHierarchy.getRootEntityType().getRepresentationStrategy().generatePropertyAccess(bootModelRootEntity, bootModelRootEntity.getVersionAttributeMapping(), runtimeModelHierarchy.getRootEntityType(), creationContext.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider()), SingularPersistentAttribute.Disposition.VERSION);
        BasicValueMapping basicValueMapping = (BasicValueMapping)bootModelRootEntity.getVersionAttributeMapping().getValueMapping();
        this.column = creationContext.getDatabaseObjectResolver().resolveColumn(basicValueMapping.getMappedColumn());
        this.valueMapper = basicValueMapping.getResolution().getValueMapper();
        this.unsavedValue = ((KeyValue)((Object)basicValueMapping)).getNullValue();
        this.versionSupport = this.valueMapper.getDomainJavaDescriptor().getVersionSupport();
        if (this.versionSupport == null) {
            throw new HibernateException("JavaTypeDescriptor [" + this.valueMapper.getDomainJavaDescriptor() + "] associated with VersionDescriptor [" + runtimeModelHierarchy.getRootEntityType().getEntityName() + "] did not define VersionSupport");
        }
        this.instantiationComplete(bootModelRootEntity.getVersionAttributeMapping(), creationContext);
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.BASIC;
    }

    @Override
    public String getUnsavedValue() {
        return this.unsavedValue;
    }

    @Override
    public VersionSupport getVersionSupport() {
        return this.versionSupport;
    }

    @Override
    public SimpleTypeDescriptor<J> getType() {
        return this;
    }

    @Override
    public SingularPersistentAttribute.SingularAttributeClassification getAttributeTypeClassification() {
        return SingularPersistentAttribute.SingularAttributeClassification.BASIC;
    }

    @Override
    public String asLoggableText() {
        return this.getContainer().asLoggableText() + '.' + this.getNavigableName();
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.column.getExpressableType();
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return (BasicJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new BasicFetch(fetchParent, this, fetchTiming, creationState);
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return null;
    }

    @Override
    public SimpleTypeDescriptor<?> getValueGraphType() {
        return this.getAttributeType();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return null;
    }
}

