/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.mode;

import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.model.domain.internal.mode.AbstractPojoInstantiator;
import org.hibernate.type.descriptor.java.spi.ManagedJavaDescriptor;

public class PojoInstantiatorImpl<J>
extends AbstractPojoInstantiator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PojoInstantiatorImpl.class);
    private final Constructor constructor = this.isAbstract() ? null : PojoInstantiatorImpl.resolveConstructor(this.getMappedPojoClass());

    public PojoInstantiatorImpl(ManagedJavaDescriptor javaTypeDescriptor) {
        super(javaTypeDescriptor.getJavaType());
    }

    private static Constructor resolveConstructor(Class mappedPojoClass) {
        try {
            return ReflectHelper.getDefaultConstructor(mappedPojoClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(mappedPojoClass.getName());
            return null;
        }
    }

    @Override
    public J instantiate(SharedSessionContractImplementor session) {
        if (this.isAbstract()) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.getMappedPojoClass());
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.getMappedPojoClass());
        }
        try {
            return (J)this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.getMappedPojoClass(), e);
        }
    }
}

