/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.mode;

import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.mode.StandardMapRepresentationStrategy;
import org.hibernate.metamodel.model.domain.internal.mode.StandardPojoRepresentationStrategy;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;

public class StandardManagedTypeRepresentationResolver
implements ManagedTypeRepresentationResolver {
    public static final StandardManagedTypeRepresentationResolver INSTANCE = new StandardManagedTypeRepresentationResolver();

    @Override
    public ManagedTypeRepresentationStrategy resolveStrategy(ManagedTypeMapping bootMapping, ManagedTypeDescriptor runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = bootMapping.getExplicitRepresentationMode();
        if (representation == null) {
            representation = runtimeDescriptor.getJavaTypeDescriptor().getJavaType() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return StandardMapRepresentationStrategy.INSTANCE;
        }
        return new StandardPojoRepresentationStrategy(bootMapping, runtimeDescriptor, creationContext);
    }
}

