/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.mode;

import java.util.Map;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.mode.DynamicMapInstantiator;
import org.hibernate.metamodel.model.domain.internal.mode.StandardMapProxyFactoryInstantiator;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Instantiator;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.ProxyFactory;

public class StandardMapRepresentationStrategy
implements ManagedTypeRepresentationStrategy {
    public static final StandardMapRepresentationStrategy INSTANCE = new StandardMapRepresentationStrategy();

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.MAP;
    }

    public Instantiator resolveInstantiator(ManagedTypeMapping bootModel, ManagedTypeDescriptor runtimeModel, BytecodeProvider bytecodeProvider) {
        return new DynamicMapInstantiator(runtimeModel.getNavigableRole());
    }

    @Override
    public <J> ProxyFactory generateProxyFactory(EntityTypeDescriptor<J> runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        return StandardMapProxyFactoryInstantiator.INSTANCE.instantiate(runtimeDescriptor, creationContext);
    }

    @Override
    public boolean isConcreteInstance(Object instance, IdentifiableTypeDescriptor<?> typeDescriptor, SessionFactoryImplementor factory) {
        if (instance instanceof Map) {
            Map mapInstance = (Map)instance;
            String name = (String)mapInstance.get("$type$");
            return typeDescriptor.getDomainTypeName().equals(name);
        }
        return false;
    }

    @Override
    public PropertyAccess generatePropertyAccess(ManagedTypeMapping bootDescriptor, PersistentAttributeMapping bootAttribute, ManagedTypeDescriptor runtimeDescriptor, BytecodeProvider bytecodeProvider) {
        return PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, bootAttribute.getName());
    }
}

