/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.mode;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractEntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ProxyFactoryInstantiator;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;

public class StandardPojoProxyFactoryInstantiator<J>
implements ProxyFactoryInstantiator<J> {
    public static final StandardPojoProxyFactoryInstantiator INSTANCE = new StandardPojoProxyFactoryInstantiator();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StandardPojoProxyFactoryInstantiator.class);

    @Override
    public ProxyFactory instantiate(EntityTypeDescriptor<J> runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        EntityIdentifier identifierDescriptor = runtimeDescriptor.getHierarchy().getIdentifierDescriptor();
        PropertyAccess propertyAccess = identifierDescriptor.asAttribute(identifierDescriptor.getJavaType()).getPropertyAccess();
        Getter idGetter = propertyAccess.getGetter();
        Setter idSetter = propertyAccess.getSetter();
        LinkedHashSet<Class> proxyInterfaces = new LinkedHashSet<Class>();
        Class mappedClass = runtimeDescriptor.getJavaTypeDescriptor().getJavaType();
        this.addProxyInterfaces(runtimeDescriptor, proxyInterfaces);
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Collection subclassTypes = runtimeDescriptor.getSubclassTypes();
        subclassTypes.forEach(inheritanceCapable -> {
            if (inheritanceCapable instanceof AbstractEntityTypeDescriptor) {
                this.addProxyInterfaces(runtimeDescriptor, proxyInterfaces);
            }
        });
        proxyInterfaces.add(HibernateProxy.class);
        runtimeDescriptor.visitAttributes(attribute -> {
            Method setterMethod;
            PropertyAccess attributePropertyAccess = attribute.getPropertyAccess();
            Method getterMethod = attributePropertyAccess.getGetter().getMethod();
            if (getterMethod != null && Modifier.isFinal(getterMethod.getModifiers())) {
                LOG.gettersOfLazyClassesCannotBeFinal(runtimeDescriptor.getEntityName(), attribute.getAttributeName());
            }
            if ((setterMethod = attributePropertyAccess.getSetter().getMethod()) != null && Modifier.isFinal(setterMethod.getModifiers())) {
                LOG.settersOfLazyClassesCannotBeFinal(runtimeDescriptor.getEntityName(), attribute.getAttributeName());
            }
        });
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Class proxyInterface = runtimeDescriptor.getConcreteProxyClass();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        ProxyFactory pf = this.buildProxyFactoryInternal(idGetter, idSetter, creationContext);
        try {
            pf.postInstantiate(runtimeDescriptor.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, identifierDescriptor instanceof EmbeddedTypeDescriptor ? (EmbeddedTypeDescriptor)((Object)identifierDescriptor) : null);
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(runtimeDescriptor.getEntityName(), he);
        }
        return pf;
    }

    private ProxyFactory buildProxyFactoryInternal(Getter idGetter, Setter idSetter, RuntimeModelCreationContext creationContext) {
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        return sessionFactory.getSessionFactoryOptions().getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory(sessionFactory);
    }

    private void addProxyInterfaces(EntityTypeDescriptor runtimeDescriptor, Set<Class> proxyInterfaces) {
        Class javaClass = runtimeDescriptor.getJavaTypeDescriptor().getJavaType();
        Class proxyInterface = runtimeDescriptor.getConcreteProxyClass();
        if (proxyInterface != null && !javaClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + runtimeDescriptor.getNavigableName());
            }
            proxyInterfaces.add(proxyInterface);
        }
    }

    private StandardPojoProxyFactoryInstantiator() {
    }
}

