/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.mode;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.mode.OptimizedPojoInstantiatorImpl;
import org.hibernate.metamodel.model.domain.internal.mode.PojoInstantiatorImpl;
import org.hibernate.metamodel.model.domain.internal.mode.StandardPojoProxyFactoryInstantiator;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Instantiator;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.ManagedJavaDescriptor;
import org.jboss.logging.Logger;

public class StandardPojoRepresentationStrategy
implements ManagedTypeRepresentationStrategy {
    private static final Logger log = Logger.getLogger(StandardPojoRepresentationStrategy.class);
    private final StrategySelector strategySelector;
    private Supplier<ReflectionOptimizer> reflectionOptimizerAccess;

    public StandardPojoRepresentationStrategy(ManagedTypeMapping bootDescriptor, ManagedTypeDescriptor runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        this.strategySelector = creationContext.getSessionFactory().getServiceRegistry().getService(StrategySelector.class);
        log.tracef("StandardPojoRepresentationStrategy created for [%s]", (Object)runtimeDescriptor);
    }

    private static ReflectionOptimizer buildReflectionOptimizer(ManagedTypeMapping bootDescriptor, ManagedTypeDescriptor runtimeDescriptor, RuntimeModelCreationContext creationContext, BytecodeProvider bytecodeProvider) {
        if (runtimeDescriptor.getJavaTypeDescriptor().getJavaType() == null) {
            return null;
        }
        final ArrayList getterNames = new ArrayList();
        final ArrayList setterNames = new ArrayList();
        final ArrayList types = new ArrayList();
        runtimeDescriptor.visitAttributes(new Consumer<NonIdPersistentAttribute>(){

            @Override
            public void accept(NonIdPersistentAttribute attribute) {
                getterNames.add(attribute.getPropertyAccess().getGetter().getMethodName());
                setterNames.add(attribute.getPropertyAccess().getSetter().getMethodName());
                types.add(attribute.getJavaTypeDescriptor());
            }
        });
        return bytecodeProvider.getReflectionOptimizer(runtimeDescriptor.getJavaTypeDescriptor().getJavaType(), getterNames.toArray(new String[0]), setterNames.toArray(new String[0]), types.toArray(new JavaTypeDescriptor[0]));
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public <J> Instantiator<J> resolveInstantiator(ManagedTypeMapping bootDescriptor, ManagedTypeDescriptor runtimeDescriptor, BytecodeProvider bytecodeProvider) {
        ReflectionOptimizer reflectionOptimizer;
        ReflectionOptimizer reflectionOptimizer2 = reflectionOptimizer = this.reflectionOptimizerAccess == null ? null : this.reflectionOptimizerAccess.get();
        if (reflectionOptimizer != null && reflectionOptimizer.getInstantiationOptimizer() != null) {
            return new OptimizedPojoInstantiatorImpl((ManagedJavaDescriptor)runtimeDescriptor.getJavaTypeDescriptor(), reflectionOptimizer);
        }
        return new PojoInstantiatorImpl((ManagedJavaDescriptor)runtimeDescriptor.getJavaTypeDescriptor());
    }

    @Override
    public <J> ProxyFactory generateProxyFactory(EntityTypeDescriptor<J> runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        return StandardPojoProxyFactoryInstantiator.INSTANCE.instantiate(runtimeDescriptor, creationContext);
    }

    @Override
    public boolean isConcreteInstance(Object entityInstance, IdentifiableTypeDescriptor<?> typeDescriptor, SessionFactoryImplementor factory) {
        if (entityInstance != null) {
            Class<?> concreteEntityClass = entityInstance.getClass();
            return concreteEntityClass.getName().equals(typeDescriptor.getDomainTypeName());
        }
        return false;
    }

    @Override
    public PropertyAccess generatePropertyAccess(ManagedTypeMapping bootDescriptor, PersistentAttributeMapping bootAttribute, ManagedTypeDescriptor runtimeDescriptor, BytecodeProvider bytecodeProvider) {
        PropertyAccessStrategy strategy = null;
        String propertyAccessorName = bootAttribute.getPropertyAccessorName();
        BuiltInPropertyAccessStrategies namedStrategy = BuiltInPropertyAccessStrategies.interpret(propertyAccessorName);
        if (namedStrategy != null) {
            strategy = namedStrategy.getStrategy();
        }
        if (strategy == null) {
            if (StringHelper.isNotEmpty(propertyAccessorName)) {
                strategy = (PropertyAccessStrategy)this.strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
            } else if (bootAttribute instanceof Backref) {
                Backref backref = (Backref)bootAttribute;
                strategy = new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
            } else if (bootAttribute instanceof IndexBackref) {
                IndexBackref indexBackref = (IndexBackref)bootAttribute;
                strategy = new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
            } else {
                strategy = BuiltInPropertyAccessStrategies.MIXED.getStrategy();
            }
        }
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", bootDescriptor.getName(), bootAttribute.getName()));
        }
        return strategy.buildPropertyAccess(runtimeDescriptor.getJavaTypeDescriptor().getJavaType(), bootAttribute.getName());
    }
}

