/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class AbstractCollectionIndex<J>
implements CollectionIndex<J> {
    private final PersistentCollectionDescriptor descriptor;
    private final NavigableRole navigableRole;
    private final int baseIndex;
    private final boolean indexSettable;

    public AbstractCollectionIndex(PersistentCollectionDescriptor descriptor, IndexedCollection bootCollectionMapping) {
        this.descriptor = descriptor;
        this.navigableRole = descriptor.getNavigableRole().append("{index}");
        this.baseIndex = bootCollectionMapping.isList() ? ((List)bootCollectionMapping).getBaseIndex() : 0;
        this.indexSettable = AbstractCollectionIndex.resolveIfIndexSettable(bootCollectionMapping);
    }

    public PersistentCollectionDescriptor getContainer() {
        return this.descriptor;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getNavigableName() {
        return "{index}";
    }

    @Override
    public int getBaseIndex() {
        return this.baseIndex;
    }

    @Override
    public boolean isSettable() {
        return this.indexSettable;
    }

    @Override
    public String asLoggableText() {
        return "PluralAttributeIndex(" + this.descriptor.getNavigableRole() + " [" + this.getJavaType() + "])";
    }

    private static boolean resolveIfIndexSettable(IndexedCollection bootCollectionMapping) {
        for (int i = 0; i < bootCollectionMapping.getIndex().getColumnSpan(); ++i) {
            if (bootCollectionMapping.getIndex().getColumnInsertability()[i]) {
                return true;
            }
            if (!bootCollectionMapping.getIndex().getColumnUpdateability()[i]) continue;
            return true;
        }
        return false;
    }
}

