/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.IdentifiableTypeMapping;
import org.hibernate.boot.model.domain.MappedJoin;
import org.hibernate.boot.model.domain.spi.EntityMappingImplementor;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataNonPojoImpl;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataPojoImpl;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.EntityEntryFactory;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.id.Assigned;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterHelper;
import org.hibernate.loader.internal.StandardMultiIdEntityLoader;
import org.hibernate.loader.internal.StandardNaturalIdLoader;
import org.hibernate.loader.internal.StandardSingleIdEntityLoader;
import org.hibernate.loader.spi.EntityLocker;
import org.hibernate.loader.spi.MultiIdEntityLoader;
import org.hibernate.loader.spi.MultiIdLoaderSelectors;
import org.hibernate.loader.spi.NaturalIdLoader;
import org.hibernate.loader.spi.SingleIdEntityLoader;
import org.hibernate.loader.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SqlAliasStemHelper;
import org.hibernate.metamodel.model.domain.internal.entity.EntityHierarchyImpl;
import org.hibernate.metamodel.model.domain.internal.entity.EntityIdentifierCompositeAggregatedImpl;
import org.hibernate.metamodel.model.domain.internal.entity.EntityIdentifierSimpleImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Instantiator;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.JoinedTableBinding;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.IdentifiableJavaDescriptor;

public abstract class AbstractEntityTypeDescriptor<J>
extends AbstractIdentifiableType<J>
implements Lockable<J> {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AbstractEntityTypeDescriptor.class);
    private final SessionFactoryImplementor factory;
    private final EntityHierarchy hierarchy;
    private final NavigableRole navigableRole;
    private final Table rootTable;
    private final List<JoinedTableBinding> secondaryTableBindings;
    private final BytecodeEnhancementMetadata bytecodeEnhancementMetadata;
    private final Instantiator<J> instantiator;
    private final String sqlAliasStem;
    private final Dialect dialect;
    private final boolean canReadFromCache;
    private final boolean canWriteToCache;
    private final boolean hasProxy;
    private final boolean selectBeforeUpdate;
    private final Class proxyInterface;
    private final int batchSize;
    private ProxyFactory proxyFactory;
    private boolean canIdentityInsertBeDelayed;
    protected final ExecuteUpdateResultCheckStyle rootUpdateResultCheckStyle;
    private final SingleIdEntityLoader customQueryLoader = null;
    private StandardSingleIdEntityLoader<J> singleIdLoader;
    private final FilterHelper filterHelper;
    private final Set<String> affectingFetchProfileNames = new HashSet<String>();
    private Map<LockMode, EntityLocker> lockers;

    public AbstractEntityTypeDescriptor(EntityMappingImplementor bootMapping, IdentifiableTypeDescriptor<? super J> superTypeDescriptor, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(bootMapping, superTypeDescriptor, AbstractEntityTypeDescriptor.resolveJavaTypeDescriptorFromJavaTypeMapping(bootMapping), creationContext);
        this.factory = creationContext.getSessionFactory();
        this.navigableRole = new NavigableRole(bootMapping.getEntityName());
        this.hierarchy = this.resolveEntityHierarchy(bootMapping, superTypeDescriptor, creationContext);
        this.rootTable = this.resolveRootTable(bootMapping, creationContext);
        this.rootUpdateResultCheckStyle = bootMapping.getUpdateResultCheckStyle();
        this.secondaryTableBindings = this.resolveSecondaryTableBindings(bootMapping, creationContext);
        RepresentationMode representation = this.getRepresentationStrategy().getMode();
        this.bytecodeEnhancementMetadata = representation == RepresentationMode.POJO ? BytecodeEnhancementMetadataPojoImpl.from(bootMapping) : new BytecodeEnhancementMetadataNonPojoImpl(bootMapping.getEntityName());
        this.instantiator = this.getRepresentationStrategy().resolveInstantiator(bootMapping, this, creationContext.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider());
        log.debugf("Instantiated persister [%s] for entity [%s (%s)]", this, bootMapping.getEntityName(), bootMapping.getJpaEntityName());
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromEntityName(bootMapping.getEntityName());
        this.dialect = this.factory.getServiceRegistry().getService(JdbcServices.class).getDialect();
        if (creationContext.getSessionFactory().getSessionFactoryOptions().isSecondLevelCacheEnabled()) {
            PersistentClass persistentClass = (PersistentClass)bootMapping;
            this.canWriteToCache = persistentClass.isCached();
            this.canReadFromCache = this.determineCanReadFromCache(persistentClass);
        } else {
            this.canWriteToCache = false;
            this.canReadFromCache = false;
        }
        this.filterHelper = new FilterHelper(bootMapping.getFilters(), this.factory);
        this.hasProxy = bootMapping.hasProxy() && !this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading();
        this.proxyInterface = bootMapping.getProxyInterface();
        creationContext.registerNavigable(this, bootMapping);
        int batch = bootMapping.getBatchSize();
        if (batch == -1) {
            batch = this.factory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.selectBeforeUpdate = bootMapping.hasSelectBeforeUpdate();
    }

    private boolean determineCanReadFromCache(PersistentClass persistentClass) {
        if (persistentClass.isCached()) {
            return true;
        }
        Iterator subclassIterator = persistentClass.getSubclassIterator();
        while (subclassIterator.hasNext()) {
            Subclass subclass = (Subclass)subclassIterator.next();
            if (!subclass.isCached()) continue;
            return true;
        }
        return false;
    }

    private EntityHierarchy resolveEntityHierarchy(IdentifiableTypeMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        if (bootMapping instanceof RootClass) {
            return new EntityHierarchyImpl(this, (RootClass)bootMapping, creationContext);
        }
        return superTypeDescriptor.getHierarchy();
    }

    private Table resolveRootTable(EntityMapping entityMapping, RuntimeModelCreationContext creationContext) {
        MappedTable rootMappedTable = entityMapping.getRootTable();
        return this.resolveTable(rootMappedTable, creationContext);
    }

    private Table resolveTable(MappedTable mappedTable, RuntimeModelCreationContext creationContext) {
        return creationContext.getDatabaseObjectResolver().resolveTable(mappedTable);
    }

    private List<JoinedTableBinding> resolveSecondaryTableBindings(EntityMapping entityMapping, RuntimeModelCreationContext creationContext) {
        Collection<MappedJoin> mappedJoins = entityMapping.getMappedJoins();
        if (mappedJoins.size() <= 0) {
            return Collections.emptyList();
        }
        if (mappedJoins.size() == 1) {
            return Collections.singletonList(this.generateJoinedTableBinding(mappedJoins.iterator().next(), creationContext));
        }
        ArrayList<JoinedTableBinding> bindings = new ArrayList<JoinedTableBinding>();
        for (MappedJoin mappedJoin : mappedJoins) {
            bindings.add(this.generateJoinedTableBinding(mappedJoin, creationContext));
        }
        return bindings;
    }

    private JoinedTableBinding generateJoinedTableBinding(MappedJoin bootJoinTable, RuntimeModelCreationContext creationContext) {
        Table joinedTable = this.resolveTable(bootJoinTable.getMappedTable(), creationContext);
        return new JoinedTableBinding(joinedTable, this.getPrimaryTable(), creationContext.getDatabaseObjectResolver().resolveForeignKey(bootJoinTable.getJoinMapping()), bootJoinTable.isOptional(), bootJoinTable.isInverse(), bootJoinTable.getUpdateResultCheckStyle());
    }

    private static <T> IdentifiableJavaDescriptor<T> resolveJavaTypeDescriptorFromJavaTypeMapping(EntityMapping entityMapping) {
        return (IdentifiableJavaDescriptor)entityMapping.getJavaTypeMapping().getJavaTypeDescriptor();
    }

    @Override
    public void afterInitialize(Object entity, SharedSessionContractImplementor session) {
    }

    @Override
    public void postInitialization(RuntimeModelCreationContext creationContext) {
        this.singleIdLoader = new StandardSingleIdEntityLoader(this);
        this.resolveIdentityInsertDelayable();
    }

    @Override
    public boolean finishInitialization(ManagedTypeMappingImplementor bootDescriptor, RuntimeModelCreationContext creationContext) {
        super.finishInitialization(bootDescriptor, creationContext);
        log.debugf("Completed initialization of descriptor [%s] for entity [%s (%s)]", this, this.getJavaTypeDescriptor().getEntityName(), this.getJavaTypeDescriptor().getJpaEntityName());
        if (this.hasProxy) {
            this.proxyFactory = this.getRepresentationStrategy().generateProxyFactory(this, creationContext);
        }
        return true;
    }

    @Override
    public boolean isBatchLoadable() {
        return this.batchSize > 1;
    }

    @Override
    public boolean hasUninitializedLazyProperties(Object object) {
        return this.bytecodeEnhancementMetadata.hasUnFetchedAttributes(object);
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return Collections.emptySet();
    }

    @Override
    public Object[] getDatabaseSnapshot(Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.tracev("Getting current persistent state for: {0}", MessageHelper.infoString((EntityTypeDescriptor)this, id, this.getFactory()));
        }
        return this.getSingleIdLoader().loadDatabaseSnapshot(id, session);
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public EntityHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean canReadFromCache() {
        return this.canReadFromCache;
    }

    @Override
    public boolean canWriteToCache() {
        return this.canWriteToCache;
    }

    @Override
    public boolean hasProxy() {
        return this.hasProxy;
    }

    @Override
    public EntityJavaDescriptor<J> getJavaTypeDescriptor() {
        return (EntityJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public String getEntityName() {
        return this.getJavaTypeDescriptor().getEntityName();
    }

    @Override
    public String getJpaEntityName() {
        return this.getJavaTypeDescriptor().getJpaEntityName();
    }

    public String getName() {
        return this.getJpaEntityName();
    }

    @Override
    public NavigableContainer getContainer() {
        return null;
    }

    @Override
    public Table getPrimaryTable() {
        return this.rootTable;
    }

    @Override
    public List<JoinedTableBinding> getSecondaryTableBindings() {
        return this.secondaryTableBindings;
    }

    public Class<J> getBindableJavaType() {
        return this.getJavaType();
    }

    @Override
    public BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.bytecodeEnhancementMetadata;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getNavigableName() {
        return this.navigableRole.getNavigableName();
    }

    @Override
    public EntityTypeDescriptor<J> getEntityDescriptor() {
        return this;
    }

    @Override
    public EntityEntryFactory getEntityEntryFactory() {
        return this.getHierarchy().getMutabilityPlan().getEntityEntryFactory();
    }

    @Override
    public List<EntityNameResolver> getEntityNameResolvers() {
        return null;
    }

    public <Y> SingularAttribute<? super J, Y> getId(Class<Y> type) {
        return this.getHierarchy().getIdentifierDescriptor().asAttribute(type);
    }

    public <Y> SingularAttribute<J, Y> getDeclaredId(Class<Y> type) {
        return this.getHierarchy().getIdentifierDescriptor().asAttribute(type);
    }

    public <Y> SingularAttribute<? super J, Y> getVersion(Class<Y> type) {
        return this.getHierarchy().getVersionDescriptor();
    }

    public <Y> SingularAttribute<J, Y> getDeclaredVersion(Class<Y> type) {
        return this.getHierarchy().getVersionDescriptor();
    }

    public boolean hasSingleIdAttribute() {
        return this.getIdentifierDescriptor() instanceof EntityIdentifierSimpleImpl || this.getIdentifierDescriptor() instanceof EntityIdentifierCompositeAggregatedImpl;
    }

    public boolean hasVersionAttribute() {
        return this.getHierarchy().getVersionDescriptor() != null;
    }

    public Set<SingularAttribute<? super J, ?>> getIdClassAttributes() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SimpleTypeDescriptor<?> getIdType() {
        return this.getHierarchy().getIdentifierDescriptor().getNavigableType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    @Override
    public SingleIdEntityLoader getSingleIdLoader() {
        if (this.customQueryLoader != null) {
            return this.customQueryLoader;
        }
        return this.singleIdLoader;
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers loadQueryInfluencers) {
        assert (this.filterHelper != null);
        return loadQueryInfluencers.hasEnabledFilters() && this.filterHelper.isAffectedBy(loadQueryInfluencers.getEnabledFilters());
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers loadQueryInfluencers) {
        for (String s : loadQueryInfluencers.getEnabledFetchProfileNames()) {
            if (!this.affectingFetchProfileNames.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers loadQueryInfluencers) {
        return loadQueryInfluencers.getFetchGraph() != null || loadQueryInfluencers.getLoadGraph() != null;
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        if (!this.getBindableJavaType().isAssignableFrom(subType)) {
            throw new IllegalArgumentException(String.format("Entity type [%s] cannot be treated as requested sub-type [%s]", this.getName(), subType.getName()));
        }
        return new SubGraphImpl(this, true, this.getTypeConfiguration().getSessionFactory());
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.makeSubGraph(this.getBindableJavaType());
    }

    protected SingleIdEntityLoader createSingleIdLoader(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        return this.singleIdLoader;
    }

    @Override
    public NaturalIdLoader getNaturalIdLoader() {
        if (!this.hasNaturalIdentifier()) {
            throw new UnsupportedOperationException("Entity [" + this.getEntityName() + "] does not define a natural-id");
        }
        return new StandardNaturalIdLoader(this);
    }

    @Override
    public MultiIdEntityLoader getMultiIdLoader(MultiIdLoaderSelectors selectors) {
        if (this.customQueryLoader != null) {
            throw new HibernateException("Cannot perform multi-id loading on an entity defined with a custom load query : " + this.getEntityName());
        }
        return new StandardMultiIdEntityLoader(this, selectors);
    }

    @Override
    public SingleUniqueKeyEntityLoader getSingleUniqueKeyLoader(Navigable navigable, LoadQueryInfluencers loadQueryInfluencers) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void lock(Object id, Object version, Object object, LockOptions lockOptions, SharedSessionContractImplementor session) throws HibernateException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public EntityLocker getLocker(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        EntityLocker entityLocker = null;
        if (this.lockers == null) {
            this.lockers = new ConcurrentHashMap<LockMode, EntityLocker>();
        } else {
            entityLocker = this.lockers.get((Object)lockOptions.getLockMode());
        }
        if (entityLocker == null) {
            throw new NotYetImplementedFor6Exception();
        }
        return entityLocker;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public TableGroup createRootTableGroup(NavigablePath navigablePath, String explicitSourceAlias, JoinType tableReferenceJoinType, LockMode lockMode, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
        TableReference primaryTableReference = this.resolvePrimaryTableReference(sqlAliasBase);
        ArrayList<TableReferenceJoin> joins = new ArrayList<TableReferenceJoin>();
        this.resolveTableReferenceJoins(primaryTableReference, sqlAliasBase, tableReferenceJoinType, joins::add);
        return new StandardTableGroup(navigablePath, this, lockMode, primaryTableReference, joins);
    }

    protected TableReference resolvePrimaryTableReference(SqlAliasBase sqlAliasBase) {
        return new TableReference(this.getPrimaryTable(), sqlAliasBase.generateNewAlias(), false);
    }

    private void resolveTableReferenceJoins(TableReference rootTableReference, SqlAliasBase sqlAliasBase, JoinType joinType, Consumer<TableReferenceJoin> collector) {
        for (JoinedTableBinding joinedTableBinding : this.getSecondaryTableBindings()) {
            collector.accept(this.createTableReferenceJoin(joinedTableBinding, rootTableReference, joinType, sqlAliasBase));
        }
    }

    protected TableReferenceJoin createTableReferenceJoin(JoinedTableBinding joinedTableBinding, TableReference rootTableReference, JoinType joinType, SqlAliasBase sqlAliasBase) {
        TableReference joinedTableReference = new TableReference(joinedTableBinding.getReferringTable(), sqlAliasBase.generateNewAlias(), joinedTableBinding.isOptional());
        return new TableReferenceJoin(joinedTableBinding.isOptional() ? JoinType.LEFT : joinType, joinedTableReference, this.generateJoinPredicate(rootTableReference, joinedTableReference, joinedTableBinding.getJoinForeignKey()));
    }

    private Predicate generateJoinPredicate(TableReference rootTableReference, TableReference joinedTableReference, ForeignKey joinForeignKey) {
        assert (rootTableReference.getTable() == joinForeignKey.getTargetTable());
        assert (joinedTableReference.getTable() == joinForeignKey.getReferringTable());
        assert (!joinForeignKey.getColumnMappings().getColumnMappings().isEmpty());
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : joinForeignKey.getColumnMappings().getColumnMappings()) {
            conjunction.add(new ComparisonPredicate(rootTableReference.resolveColumnReference(columnMapping.getTargetColumn()), ComparisonOperator.EQUAL, joinedTableReference.resolveColumnReference(columnMapping.getReferringColumn())));
        }
        return conjunction;
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        TableReference root;
        if (joinCollector.getPrimaryTableReference() == null) {
            root = this.resolvePrimaryTableReference(sqlAliasBase);
            joinCollector.addPrimaryReference(root);
        } else {
            root = lhs.locateTableReference(this.getPrimaryTable());
        }
        this.resolveTableReferenceJoins(root, sqlAliasBase, joinType, joinCollector::addSecondaryReference);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public String getRootTableName() {
        return ((PhysicalTable)this.rootTable).getTableName().render(this.dialect);
    }

    @Override
    public String[] getRootTableIdentifierColumnNames() {
        List<PhysicalColumn> columns = this.rootTable.getPrimaryKey().getColumns();
        String[] columnNames = new String[columns.size()];
        int i = 0;
        for (PhysicalColumn column : columns) {
            columnNames[i] = column.getName().render(this.dialect);
            ++i;
        }
        return columnNames;
    }

    @Override
    public String getVersionColumnName() {
        return ((PhysicalColumn)this.getHierarchy().getVersionDescriptor().getBoundColumn()).getName().render(this.dialect);
    }

    @Override
    public boolean hasNaturalIdentifier() {
        return this.getHierarchy().getNaturalIdDescriptor() != null;
    }

    @Override
    public Object instantiate(Object id, SharedSessionContractImplementor session) {
        J instance = this.instantiator.instantiate(session);
        this.setIdentifier(instance, id, session);
        return instance;
    }

    @Override
    public Object createProxy(Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.proxyFactory.getProxy((Serializable)id, session);
    }

    @Override
    public boolean isSelectBeforeUpdateRequired() {
        return this.selectBeforeUpdate;
    }

    @Override
    public boolean canIdentityInsertBeDelayed() {
        return this.canIdentityInsertBeDelayed;
    }

    @Override
    public boolean isInstance(Object object) {
        return this.instantiator.isInstance(object, this.getFactory());
    }

    @Override
    public void setPropertyValues(Object object, Object[] values) {
        super.setPropertyValues(object, values);
    }

    @Override
    public void resetIdentifier(Object entity, Object currentId, Object currentVersion, SharedSessionContractImplementor session) {
        if (!(this.getHierarchy().getIdentifierDescriptor().getIdentifierValueGenerator() instanceof Assigned)) {
            this.setIdentifier(entity, this.getHierarchy().getIdentifierDescriptor().getUnsavedValue().getDefaultValue(currentId), session);
            if (this.getHierarchy().getVersionDescriptor() != null) {
                this.getHierarchy().getVersionDescriptor().getUnsavedValue();
                this.getHierarchy().getVersionDescriptor().getPropertyAccess().getSetter().set(entity, this.getHierarchy().getVersionDescriptor().getUnsavedValue(), session.getFactory());
            }
        }
    }

    @Override
    public Object getVersion(Object object) throws HibernateException {
        if (this.getHierarchy().getVersionDescriptor() == null) {
            return null;
        }
        return this.getHierarchy().getVersionDescriptor().getPropertyAccess().getGetter().get(object);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(`%s`)@%s", this.getClass().getSimpleName(), this.getEntityName(), this.hashCode());
    }

    @Override
    public void insert(Object id, Object[] fields, Object object, SharedSessionContractImplementor session) {
        this.insertInternal(id, fields, object, session);
    }

    protected Object insertInternal(Object id, Object[] fields, Object object, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Object insert(Object[] fields, Object object, SharedSessionContractImplementor session) {
        return this.insertInternal(null, fields, object, session);
    }

    public Class getProxyInterface() {
        return this.proxyInterface;
    }

    @Override
    public Class getConcreteProxyClass() {
        if (this.getRepresentationStrategy().getMode().equals((Object)RepresentationMode.POJO)) {
            return this.getProxyInterface();
        }
        return Map.class;
    }

    private void resolveIdentityInsertDelayable() {
        this.canIdentityInsertBeDelayed = true;
        if (this.getIdentifierDescriptor().getIdentifierValueGenerator() instanceof PostInsertIdentifierGenerator) {
            for (NonIdPersistentAttribute attribute : this.getPersistentAttributes()) {
                if (!this.isAttributeSelfReferencing(attribute)) continue;
                this.canIdentityInsertBeDelayed = false;
            }
        }
    }

    @Override
    public void afterReassociate(Object entity, SharedSessionContractImplementor session) {
        this.handleNaturalIdReattachment(entity, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAttributeSelfReferencing(NonIdPersistentAttribute attribute) {
        if (attribute.isAssociation()) {
            PersistentCollectionDescriptor collectionDescriptor;
            if (attribute.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                if (!this.getMappedClass().equals(attribute.getJavaType())) return false;
                return true;
            }
            if (attribute.isCollection() && (collectionDescriptor = this.getFactory().getMetamodel().getCollectionDescriptor(attribute.getNavigableRole())).isInverse() && !collectionDescriptor.findEntityOwnerDescriptor().equals(this)) return false;
        }
        if (!attribute.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) return false;
        SingularPersistentAttributeEmbedded embedded = (SingularPersistentAttributeEmbedded)attribute;
        EmbeddedTypeDescriptor embeddedDescriptor = embedded.getEmbeddedDescriptor();
        for (NonIdPersistentAttribute embeddedAttribute : embeddedDescriptor.getPersistentAttributes()) {
            if (!this.isAttributeSelfReferencing(embeddedAttribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areEqual(J x, J y) throws HibernateException {
        if (x == null || y == null) {
            return x == y;
        }
        if (this.getHierarchy().getIdentifierDescriptor() == null) {
            return super.areEqual(x, y);
        }
        Class mappedClass = this.getMappedClass();
        Object xid = x instanceof HibernateProxy ? ((HibernateProxy)x).getHibernateLazyInitializer().getIdentifier() : (mappedClass.isAssignableFrom(x.getClass()) ? this.getIdentifier(x) : x);
        Object yid = y instanceof HibernateProxy ? ((HibernateProxy)y).getHibernateLazyInitializer().getIdentifier() : (mappedClass.isAssignableFrom(y.getClass()) ? this.getIdentifier(y) : y);
        return this.getIdentifierType().areEqual(xid, yid);
    }

    @Override
    public int extractHashCode(J o) {
        Class mappedClass;
        if (this.getHierarchy().getIdentifierDescriptor() == null) {
            return super.extractHashCode(o);
        }
        Object id = o instanceof HibernateProxy ? ((HibernateProxy)o).getHibernateLazyInitializer().getIdentifier() : ((mappedClass = this.getMappedClass()).isAssignableFrom(o.getClass()) ? this.getIdentifier(o) : o);
        return this.getIdentifierType().extractHashCode(id);
    }

    @Override
    public EntityTypeDescriptor getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory) {
        return this.getSubclassEntityDescriptor(instance, factory);
    }

    @Override
    public EntityTypeDescriptor getSubclassEntityDescriptor(Object instance, SessionFactoryImplementor factory) {
        IdentifiableTypeDescriptor subTypeMatch;
        if (this.getRepresentationStrategy().isConcreteInstance(instance, this, factory)) {
            return this;
        }
        if (!this.getSubclassTypes().isEmpty() && (subTypeMatch = this.findMatchingSubTypeDescriptors(typeDescriptor -> typeDescriptor.getRepresentationStrategy().isConcreteInstance(instance, (IdentifiableTypeDescriptor<?>)typeDescriptor, factory))) != null) {
            return (EntityTypeDescriptor)subTypeMatch;
        }
        return this;
    }

    @Override
    public boolean hasCascades() {
        for (StateArrayContributor<?> contributor : this.getStateArrayContributors()) {
            if (contributor.getCascadeStyle() == CascadeStyles.NONE) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type getIdentifierType() {
        return this.getHierarchy().getIdentifierDescriptor().getNavigableType();
    }

    private void handleNaturalIdReattachment(Object entity, SharedSessionContractImplementor session) {
        if (!this.hasNaturalIdentifier()) {
            return;
        }
        if (!this.getHierarchy().getNaturalIdDescriptor().isMutable()) {
            return;
        }
        PersistenceContext.NaturalIdHelper naturalIdHelper = session.getPersistenceContext().getNaturalIdHelper();
        Object id = this.getIdentifier(entity);
        Object[] entitySnapshot = session.getPersistenceContext().getDatabaseSnapshot(id, this);
        Object[] naturalIdSnapshot = entitySnapshot == StatefulPersistenceContext.NO_ROW ? null : naturalIdHelper.extractNaturalIdValues(entitySnapshot, (EntityTypeDescriptor)this);
        naturalIdHelper.removeSharedNaturalIdCrossReference(this, id, naturalIdSnapshot);
        naturalIdHelper.manageLocalNaturalIdCrossReference(this, id, naturalIdHelper.extractNaturalIdValues(entity, (EntityTypeDescriptor)this), naturalIdSnapshot, CachedNaturalIdValueSource.UPDATE);
    }
}

