/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.boot.model.domain.IdentifiableTypeMapping;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractManagedType;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.InheritanceCapable;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.type.descriptor.java.spi.IdentifiableJavaDescriptor;

public abstract class AbstractIdentifiableType<T>
extends AbstractManagedType<T>
implements IdentifiableTypeDescriptor<T> {
    public AbstractIdentifiableType(IdentifiableTypeMapping bootMapping, IdentifiableTypeDescriptor<? super T> superTypeDescriptor, IdentifiableJavaDescriptor<T> javaTypeDescriptor, RuntimeModelCreationContext creationContext) {
        super(bootMapping, superTypeDescriptor, javaTypeDescriptor, creationContext);
        if (superTypeDescriptor != null) {
            superTypeDescriptor.getInFlightAccess().addSubTypeDescriptor(this);
        }
    }

    @Override
    protected IdentifiableTypeDescriptor.InFlightAccess<T> createInFlightAccess() {
        return new InFlightAccessImpl(super.createInFlightAccess());
    }

    @Override
    public IdentifiableTypeDescriptor.InFlightAccess<T> getInFlightAccess() {
        return (IdentifiableTypeDescriptor.InFlightAccess)super.getInFlightAccess();
    }

    @Override
    public IdentifiableJavaDescriptor<T> getJavaTypeDescriptor() {
        return (IdentifiableJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public IdentifiableTypeDescriptor<? super T> getSuperclassType() {
        return (IdentifiableTypeDescriptor)super.getSuperclassType();
    }

    @Override
    public void visitDeclaredNavigables(NavigableVisitationStrategy visitor) {
        this.getHierarchy().getIdentifierDescriptor().visitNavigable(visitor);
        super.visitDeclaredNavigables(visitor);
    }

    @Override
    public void visitStateArrayContributors(Consumer<StateArrayContributor<?>> consumer) {
        super.visitStateArrayContributors(consumer);
    }

    @Override
    public void visitKeyFetchables(Consumer<Fetchable> fetchableConsumer) {
        if (this.getHierarchy().getIdentifierDescriptor() instanceof NavigableContainer) {
            ((NavigableContainer)((Object)this.getHierarchy().getIdentifierDescriptor())).visitFetchables(fetchableConsumer);
        }
    }

    @Override
    public <N> Navigable<N> findDeclaredNavigable(String navigableName) {
        Navigable navigable = super.findDeclaredNavigable(navigableName);
        if (navigable == null && this.getHierarchy().getRootEntityType().equals(this)) {
            navigable = this.getHierarchy().findNavigable(navigableName);
        }
        return navigable;
    }

    @Override
    public Navigable findNavigable(String navigableName) {
        String[] navigableNames = navigableName.split("\\.");
        String name = navigableNames[0];
        Navigable navigable = super.findDeclaredNavigable(name);
        if (navigable == null) {
            navigable = this.getHierarchy().findNavigable(name);
        }
        for (int i = 1; i < navigableNames.length; ++i) {
            navigable = ((NavigableContainer)navigable).findNavigable(navigableNames[i]);
        }
        return navigable;
    }

    @Override
    public void visitSubTypeDescriptors(Consumer<IdentifiableTypeDescriptor<? extends T>> action) {
        Collection subclassTypes = this.getSubclassTypes();
        for (InheritanceCapable subclassType : subclassTypes) {
            action.accept((IdentifiableTypeDescriptor)subclassType);
        }
    }

    @Override
    public void visitAllSubTypeDescriptors(Consumer<IdentifiableTypeDescriptor<? extends T>> action) {
        Collection subclassTypes = this.getSubclassTypes();
        for (IdentifiableTypeDescriptor identifiableTypeDescriptor : subclassTypes) {
            action.accept(identifiableTypeDescriptor);
            identifiableTypeDescriptor.visitAllSubTypeDescriptors(action);
        }
    }

    @Override
    public IdentifiableTypeDescriptor findMatchingSubTypeDescriptors(Predicate<IdentifiableTypeDescriptor<? extends T>> matcher) {
        if (matcher.test(this)) {
            return this;
        }
        Collection subclassTypes = this.getSubclassTypes();
        for (IdentifiableTypeDescriptor identifiableTypeDescriptor : subclassTypes) {
            IdentifiableTypeDescriptor matched = identifiableTypeDescriptor.findMatchingSubTypeDescriptors(matcher);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    protected class InFlightAccessImpl
    implements IdentifiableTypeDescriptor.InFlightAccess<T> {
        private final ManagedTypeDescriptor.InFlightAccess managedTypeAccess;

        private InFlightAccessImpl(ManagedTypeDescriptor.InFlightAccess managedTypeAccess) {
            this.managedTypeAccess = managedTypeAccess;
        }

        @Override
        public void addAttribute(PersistentAttributeDescriptor attribute) {
            this.managedTypeAccess.addAttribute(attribute);
        }

        @Override
        public void addSubTypeDescriptor(IdentifiableTypeDescriptor subTypeDescriptor) {
            AbstractIdentifiableType.this.addSubclassDescriptor(subTypeDescriptor);
        }

        @Override
        public void finishUp() {
            this.managedTypeAccess.finishUp();
        }
    }
}

