/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.IdentifiableTypeMapping;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.DomainModelHelper;
import org.hibernate.metamodel.model.domain.spi.InheritanceCapable;
import org.hibernate.metamodel.model.domain.spi.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.metamodel.model.domain.spi.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.type.descriptor.java.spi.ManagedJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public abstract class AbstractManagedType<J>
implements InheritanceCapable<J> {
    private static final Logger log = Logger.getLogger(AbstractManagedType.class);
    private final ManagedJavaDescriptor<J> javaTypeDescriptor;
    private final TypeConfiguration typeConfiguration;
    private final InheritanceCapable<? super J> superTypeDescriptor;
    private final Set<InheritanceCapable<? extends J>> subclassTypes = ConcurrentHashMap.newKeySet();
    private final Object discriminatorValue;
    private ManagedTypeRepresentationStrategy representationStrategy;
    private List<NonIdPersistentAttribute> declaredAttributes;
    private List<NonIdPersistentAttribute> attributes;
    private List<StateArrayContributor<?>> stateArrayContributors;
    private Map<String, NonIdPersistentAttribute> declaredAttributesByName;
    private transient ManagedTypeDescriptor.InFlightAccess<J> inFlightAccess;
    private boolean fullyInitialized;
    private Boolean hasMutableProperties;

    public AbstractManagedType(ManagedTypeMapping bootDescriptor, InheritanceCapable<? super J> superTypeDescriptor, ManagedJavaDescriptor<J> javaTypeDescriptor, RuntimeModelCreationContext creationContext) {
        this.superTypeDescriptor = superTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.discriminatorValue = bootDescriptor.getDiscriminatorValue();
        this.typeConfiguration = creationContext.getTypeConfiguration();
        this.representationStrategy = creationContext.getRepresentationStrategySelector().resolveStrategy(bootDescriptor, this, creationContext);
        this.inFlightAccess = this.createInFlightAccess();
    }

    protected ManagedTypeDescriptor.InFlightAccess<J> createInFlightAccess() {
        return new InFlightAccessImpl();
    }

    @Override
    public boolean finishInitialization(ManagedTypeMappingImplementor bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (!this.fullyInitialized) {
            this.tryFinishInitialization(bootDescriptor, creationContext);
            this.fullyInitialized = true;
        }
        return true;
    }

    private void tryFinishInitialization(ManagedTypeMappingImplementor bootDescriptor, RuntimeModelCreationContext creationContext) {
        int declaredAttributeCount = bootDescriptor.getDeclaredPersistentAttributes().size();
        this.declaredAttributes = CollectionHelper.arrayList(declaredAttributeCount);
        this.declaredAttributesByName = CollectionHelper.concurrentMap(declaredAttributeCount);
        this.stateArrayContributors = new ArrayList();
        if (this.superTypeDescriptor != null) {
            this.attributes = CollectionHelper.arrayList(this.superTypeDescriptor.getPersistentAttributes().size() + declaredAttributeCount);
            this.attributes.addAll(this.superTypeDescriptor.getPersistentAttributes());
            this.stateArrayContributors.addAll(this.superTypeDescriptor.getStateArrayContributors());
        } else {
            this.attributes = CollectionHelper.arrayList(declaredAttributeCount);
        }
        this.createAttributes(bootDescriptor, creationContext, bootDescriptor.getDeclaredPersistentAttributes());
        if (bootDescriptor instanceof IdentifiableTypeMapping) {
            this.addJoinDeclaredAttributes((IdentifiableTypeMapping)((Object)bootDescriptor), creationContext);
        }
        this.inFlightAccess.finishUp();
    }

    protected void addSubclassDescriptor(InheritanceCapable<? extends J> subclassType) {
        log.debugf("Adding runtime descriptor [%s] as subclass for ManagedType [%s]", (Object)subclassType.getJavaTypeDescriptor().getTypeName(), (Object)this.getJavaTypeDescriptor().getTypeName());
        this.subclassTypes.add(subclassType);
    }

    @Override
    public Collection<InheritanceCapable<? extends J>> getSubclassTypes() {
        return this.subclassTypes;
    }

    @Override
    public boolean isSubclassTypeName(String name) {
        if (this.getDomainTypeName().equals(name)) {
            return true;
        }
        if (!this.getSubclassTypes().isEmpty()) {
            for (InheritanceCapable<J> subclassType : this.getSubclassTypes()) {
                if (!subclassType.isSubclassTypeName(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public ManagedTypeRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public InheritanceCapable<? super J> getSuperclassType() {
        return this.superTypeDescriptor;
    }

    @Override
    public ManagedJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public boolean canCompositeContainCollections() {
        return true;
    }

    @Override
    public <N> Navigable<N> findDeclaredNavigable(String navigableName) {
        return this.declaredAttributesByName.get(navigableName);
    }

    @Override
    public NonIdPersistentAttribute<? super J, ?> findPersistentAttribute(String name) {
        NonIdPersistentAttribute superPersistentAttribute;
        NonIdPersistentAttribute<J, ?> declaredPersistentAttribute = this.findDeclaredPersistentAttribute(name);
        if (declaredPersistentAttribute != null) {
            return declaredPersistentAttribute;
        }
        if (this.getSuperclassType() != null && (superPersistentAttribute = this.getSuperclassType().findPersistentAttribute(name)) != null) {
            return superPersistentAttribute;
        }
        return null;
    }

    @Override
    public NonIdPersistentAttribute<? super J, ?> findDeclaredPersistentAttribute(String name) {
        if (this.declaredAttributesByName == null) {
            return null;
        }
        return this.declaredAttributesByName.get(name);
    }

    @Override
    public List<NonIdPersistentAttribute> getPersistentAttributes() {
        return this.attributes;
    }

    @Override
    public List<NonIdPersistentAttribute> getDeclaredPersistentAttributes() {
        return this.declaredAttributes;
    }

    @Override
    public void visitStateArrayContributors(Consumer<StateArrayContributor<?>> consumer) {
        this.visitAttributes(attribute -> {
            if (attribute != null) {
                consumer.accept((StateArrayContributor<?>)attribute);
            }
        });
    }

    @Override
    public boolean hasMutableProperties() {
        if (this.hasMutableProperties == null) {
            this.hasMutableProperties = this.lookForMutableAttributes();
        }
        return this.hasMutableProperties;
    }

    private Boolean lookForMutableAttributes() {
        if (this.superTypeDescriptor != null && this.superTypeDescriptor.hasMutableProperties()) {
            return true;
        }
        for (NonIdPersistentAttribute attribute : this.declaredAttributes) {
            if (!attribute.isUpdatable()) continue;
            return true;
        }
        return false;
    }

    protected <R extends PersistentAttributeDescriptor> void collectDeclaredAttributes(Collection<R> collection, Class<R> restrictionType) {
        for (PersistentAttributeDescriptor persistentAttributeDescriptor : this.declaredAttributes) {
            if (!restrictionType.isInstance(persistentAttributeDescriptor)) continue;
            collection.add(persistentAttributeDescriptor);
        }
    }

    protected <R extends PersistentAttributeDescriptor> void collectAttributes(Collection<R> collection, Class<R> restrictionType) {
        for (PersistentAttributeDescriptor persistentAttributeDescriptor : this.attributes) {
            if (restrictionType != null && !restrictionType.isInstance(persistentAttributeDescriptor)) continue;
            collection.add(persistentAttributeDescriptor);
        }
    }

    public Set<Attribute<? super J, ?>> getAttributes() {
        return new HashSet(this.attributes);
    }

    public Set<Attribute<J, ?>> getDeclaredAttributes() {
        return new HashSet(this.declaredAttributes);
    }

    public Set<SingularAttribute<? super J, ?>> getSingularAttributes() {
        HashSet jpaAttributes = new HashSet();
        this.collectAttributes(jpaAttributes, SingularPersistentAttribute.class);
        return jpaAttributes;
    }

    public Set<SingularAttribute<J, ?>> getDeclaredSingularAttributes() {
        HashSet jpaAttributes = new HashSet();
        this.collectDeclaredAttributes(jpaAttributes, SingularPersistentAttribute.class);
        return jpaAttributes;
    }

    public Set<PluralAttribute<? super J, ?, ?>> getPluralAttributes() {
        HashSet attributes = new HashSet();
        this.collectAttributes(attributes, PluralPersistentAttribute.class);
        return attributes;
    }

    public Set<PluralAttribute<J, ?, ?>> getDeclaredPluralAttributes() {
        HashSet attributes = new HashSet();
        this.collectDeclaredAttributes(attributes, PluralPersistentAttribute.class);
        return attributes;
    }

    @Override
    public Navigable findNavigable(String navigableName) {
        Navigable attribute = this.findDeclaredPersistentAttribute(navigableName);
        if (attribute == null && this.getSuperclassType() != null) {
            attribute = this.getSuperclassType().findNavigable(navigableName);
        }
        return attribute;
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.visitDeclaredNavigables(visitor);
        if (this.getSuperclassType() != null) {
            this.getSuperclassType().visitNavigables(visitor);
        }
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.visitStateArrayContributors(fetchableConsumer::accept);
    }

    @Override
    public void visitDeclaredNavigables(NavigableVisitationStrategy visitor) {
        for (PersistentAttributeDescriptor persistentAttributeDescriptor : this.declaredAttributesByName.values()) {
            persistentAttributeDescriptor.visitNavigable(visitor);
        }
    }

    @Override
    public PersistentAttributeDescriptor<? super J, ?> getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    protected PersistentAttributeDescriptor<? super J, ?> getAttribute(String name, Class resultType) {
        NonIdPersistentAttribute<Object, Object> persistentAttribute = this.findDeclaredPersistentAttribute(name, resultType);
        if (persistentAttribute == null && this.getSuperclassType() != null) {
            persistentAttribute = this.getSuperclassType().findDeclaredPersistentAttribute(name, resultType);
        }
        if (persistentAttribute == null) {
            throw new IllegalArgumentException("Could not resolve attribute named [" + name + "] relative to [" + this.asLoggableText() + "]");
        }
        return persistentAttribute;
    }

    @Override
    public NonIdPersistentAttribute<? super J, ?> findDeclaredPersistentAttribute(String name, Class resultType) {
        NonIdPersistentAttribute ormPersistentAttribute = this.declaredAttributesByName.get(name);
        if (ormPersistentAttribute == null) {
            return null;
        }
        if (ormPersistentAttribute instanceof SingularPersistentAttribute) {
            this.checkAttributeType((SingularPersistentAttribute)((Object)ormPersistentAttribute), resultType);
        } else {
            this.checkAttributeType((PluralPersistentAttribute)ormPersistentAttribute, resultType);
        }
        return ormPersistentAttribute;
    }

    protected void checkAttributeType(SingularPersistentAttribute ormAttribute, Class resultType) {
        this.checkType(ormAttribute.getName(), ormAttribute.getJavaType(), resultType);
    }

    protected void checkAttributeType(PluralPersistentAttribute ormAttribute, Class resultType) {
        this.checkType(ormAttribute.getName(), ormAttribute.getElementType().getJavaType(), resultType);
    }

    protected void checkType(String name, Class attributeType, Class resultType) {
        if (resultType != null && attributeType != null && !resultType.isAssignableFrom(attributeType)) {
            throw new IllegalArgumentException("Found attribute for given name [" + name + "], but its type [" + attributeType + "] is not assignable to the requested type [" + resultType + "]");
        }
    }

    @Override
    public NonIdPersistentAttribute getDeclaredAttribute(String name) {
        return this.getDeclaredAttribute(name, null);
    }

    public NonIdPersistentAttribute getDeclaredAttribute(String name, Class javaType) {
        NonIdPersistentAttribute<J, ?> persistentAttribute = this.findDeclaredPersistentAttribute(name, javaType);
        if (persistentAttribute == null) {
            throw new IllegalArgumentException("Could not resolve attribute named [" + name + "] relative to [" + this.asLoggableText() + "]");
        }
        return persistentAttribute;
    }

    public SingularPersistentAttribute getSingularAttribute(String name) {
        return this.getSingularAttribute(name, null);
    }

    public SingularPersistentAttribute getSingularAttribute(String name, Class type) {
        return (SingularPersistentAttribute)this.getAttribute(name, type);
    }

    public SingularAttribute getDeclaredSingularAttribute(String name) {
        return this.getDeclaredSingularAttribute(name, null);
    }

    public SingularPersistentAttribute getDeclaredSingularAttribute(String name, Class type) {
        return (SingularPersistentAttribute)((Object)this.getDeclaredAttribute(name, type));
    }

    public BagPersistentAttribute getCollection(String name) {
        return this.getCollection(name, (Class)null);
    }

    public BagPersistentAttribute getCollection(String name, Class elementType) {
        return (BagPersistentAttribute)this.getAttribute(name, elementType);
    }

    public BagPersistentAttribute getDeclaredCollection(String name) {
        return this.getDeclaredCollection(name, null);
    }

    public BagPersistentAttribute getDeclaredCollection(String name, Class elementType) {
        return (BagPersistentAttribute)this.getDeclaredAttribute(name, elementType);
    }

    public ListPersistentAttribute getList(String name) {
        return this.getList(name, null);
    }

    public ListPersistentAttribute getList(String name, Class elementType) {
        return (ListPersistentAttribute)this.getAttribute(name, elementType);
    }

    public ListPersistentAttribute getDeclaredList(String name) {
        return this.getDeclaredList(name, null);
    }

    public ListPersistentAttribute getDeclaredList(String name, Class elementType) {
        return (ListPersistentAttribute)this.getDeclaredAttribute(name, elementType);
    }

    public MapPersistentAttribute getMap(String name) {
        return this.getMap(name, null, null);
    }

    public MapPersistentAttribute getMap(String name, Class keyType, Class valueType) {
        MapPersistentAttribute mapAttribute = (MapPersistentAttribute)this.getAttribute(name, valueType);
        if (mapAttribute == null) {
            return null;
        }
        this.checkMapKeyType(name, mapAttribute.getKeyJavaType(), keyType);
        return mapAttribute;
    }

    private void checkMapKeyType(String name, Class attributeType, Class resultType) {
        this.checkType(name + ".key", attributeType, resultType);
    }

    public MapPersistentAttribute getDeclaredMap(String name) {
        return this.getDeclaredMap(name, null, null);
    }

    public MapPersistentAttribute getDeclaredMap(String name, Class keyType, Class valueType) {
        MapPersistentAttribute mapAttribute = (MapPersistentAttribute)this.getDeclaredAttribute(name, valueType);
        if (mapAttribute == null) {
            return null;
        }
        this.checkMapKeyType(name, keyType, mapAttribute.getKeyJavaType());
        return mapAttribute;
    }

    public SetPersistentAttribute getSet(String name) {
        return this.getSet(name, null);
    }

    public SetPersistentAttribute getSet(String name, Class elementType) {
        return (SetPersistentAttribute)this.getAttribute(name, elementType);
    }

    public SetPersistentAttribute getDeclaredSet(String name) {
        return this.getDeclaredSet(name, null);
    }

    public SetPersistentAttribute getDeclaredSet(String name, Class elementType) {
        return (SetPersistentAttribute)this.getDeclaredAttribute(name, elementType);
    }

    @Override
    public List<StateArrayContributor<?>> getStateArrayContributors() {
        return this.stateArrayContributors;
    }

    private void addJoinDeclaredAttributes(IdentifiableTypeMapping bootDescriptor, RuntimeModelCreationContext creationContext) {
        ArrayList<PersistentAttributeMapping> declaredPersistentAttributes = new ArrayList<PersistentAttributeMapping>();
        bootDescriptor.getMappedJoins().forEach(tableJoin -> declaredPersistentAttributes.addAll(tableJoin.getDeclaredPersistentAttributes()));
        this.createAttributes(bootDescriptor, creationContext, declaredPersistentAttributes);
    }

    private void createAttributes(ManagedTypeMapping bootContainer, RuntimeModelCreationContext creationContext, List<PersistentAttributeMapping> attributes) {
        attributes.forEach(attributeMapping -> this.createAttribute((PersistentAttributeMapping)attributeMapping, bootContainer, creationContext));
    }

    private void createAttribute(PersistentAttributeMapping attributeMapping, ManagedTypeMapping bootContainer, RuntimeModelCreationContext creationContext) {
        PersistentAttributeDescriptor attribute = attributeMapping.makeRuntimeAttribute(this, bootContainer, SingularPersistentAttribute.Disposition.NORMAL, creationContext);
        if (!NonIdPersistentAttribute.class.isInstance(attribute)) {
            throw new HibernateException(String.format(Locale.ROOT, "Boot-time attribute descriptor [%s] made non-NonIdPersistentAttribute, while a NonIdPersistentAttribute was expected : %s", attributeMapping, attribute));
        }
        this.getInFlightAccess().addAttribute(attribute);
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return new SubGraphImpl(this, true, this.typeConfiguration.getSessionFactory());
    }

    @Override
    public <S extends J> ManagedTypeDescriptor<S> findSubType(String subTypeName) {
        return DomainModelHelper.resolveSubType(this, subTypeName, this.typeConfiguration.getSessionFactory());
    }

    @Override
    public <S extends J> ManagedTypeDescriptor<S> findSubType(Class<S> subType) {
        return DomainModelHelper.resolveSubType(this, subType, this.typeConfiguration.getSessionFactory());
    }

    @Override
    public ManagedTypeDescriptor.InFlightAccess<J> getInFlightAccess() {
        if (this.inFlightAccess == null) {
            throw new IllegalStateException("Type has been locked");
        }
        return this.inFlightAccess;
    }

    protected class InFlightAccessImpl
    implements ManagedTypeDescriptor.InFlightAccess<J> {
        final List<NonIdPersistentAttribute> collectedAttributes = new ArrayList<NonIdPersistentAttribute>();

        protected InFlightAccessImpl() {
        }

        @Override
        public void addAttribute(PersistentAttributeDescriptor<J, ?> attribute) {
            this.collectedAttributes.add((NonIdPersistentAttribute)attribute);
        }

        @Override
        public void finishUp() {
            this.collectedAttributes.sort(Comparator.comparing(PersistentAttributeDescriptor::getName));
            for (NonIdPersistentAttribute attribute : this.collectedAttributes) {
                attribute.setStateArrayPosition(AbstractManagedType.this.getStateArrayContributors().size());
                AbstractManagedType.this.attributes.add(attribute);
                AbstractManagedType.this.declaredAttributes.add(attribute);
                AbstractManagedType.this.declaredAttributesByName.putIfAbsent(attribute.getName(), attribute);
                AbstractManagedType.this.stateArrayContributors.add(attribute);
            }
            AbstractManagedType.this.inFlightAccess = null;
        }
    }
}

