/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.DomainModelHelper;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class AbstractNonIdSingularPersistentAttribute<O, J>
extends AbstractSingularPersistentAttribute<O, J>
implements NonIdPersistentAttribute<O, J> {
    private final boolean nullable;
    private final boolean insertable;
    private final boolean updatable;
    private final boolean includedInDirtyChecking;
    private final CascadeStyle cascadeStyle;
    private int stateArrayPosition;
    protected MutabilityPlan<J> mutabilityPlan;

    public AbstractNonIdSingularPersistentAttribute(ManagedTypeDescriptor<O> runtimeContainer, PersistentAttributeMapping bootAttribute, PropertyAccess propertyAccess, SingularPersistentAttribute.Disposition disposition) {
        super(runtimeContainer, bootAttribute, propertyAccess, disposition);
        this.nullable = bootAttribute.isOptional();
        this.insertable = bootAttribute.isInsertable();
        this.updatable = bootAttribute.isUpdateable();
        this.includedInDirtyChecking = bootAttribute.isIncludedInDirtyChecking();
        this.cascadeStyle = DomainModelHelper.determineCascadeStyle(bootAttribute.getCascade());
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public void setStateArrayPosition(int position) {
        this.stateArrayPosition = position;
    }

    protected void instantiationComplete(PersistentAttributeMapping bootModelAttribute, RuntimeModelCreationContext context) {
        this.mutabilityPlan = this.getJavaTypeDescriptor().getMutabilityPlan();
    }

    @Override
    public Class<J> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isOptional() {
        return this.isNullable();
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean isIncludedInDirtyChecking() {
        return this.includedInDirtyChecking;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void collectNonNullableTransientEntities(Object value, ForeignKeys.Nullifier nullifier, NonNullableTransientDependencies nonNullableTransientEntities, SharedSessionContractImplementor session) {
    }
}

