/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public abstract class AbstractPersistentAttribute<O, J>
implements PersistentAttributeDescriptor<O, J> {
    private final ManagedTypeDescriptor<O> container;
    private final JavaTypeDescriptor<J> javaTypeDescriptor;
    private final PropertyAccess access;
    private final boolean includedInOptimisticLocking;
    private final NavigableRole navigableRole;

    public AbstractPersistentAttribute(ManagedTypeDescriptor<O> container, PersistentAttributeMapping bootModelAttribute, PropertyAccess propertyAccess) {
        this.container = container;
        this.javaTypeDescriptor = bootModelAttribute.getValueMapping().getJavaTypeMapping().getJavaTypeDescriptor();
        this.access = propertyAccess;
        this.includedInOptimisticLocking = bootModelAttribute.isIncludedInOptimisticLocking();
        this.navigableRole = container.getNavigableRole().append(bootModelAttribute.getName());
    }

    @Override
    public ManagedTypeDescriptor<O> getContainer() {
        return this.container;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getAttributeName() {
        return this.getNavigableRole().getNavigableName();
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.access;
    }

    @Override
    public JavaTypeDescriptor<J> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.includedInOptimisticLocking;
    }
}

