/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.EmbeddedValueMapping;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.spi.entry.StructuredMapCacheEntry;
import org.hibernate.cache.spi.entry.UnstructuredCacheEntry;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.internal.CollectionLoaderImpl;
import org.hibernate.loader.spi.CollectionLoader;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.internal.SqlAliasStemHelper;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractCreationExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.BasicCollectionElementImpl;
import org.hibernate.metamodel.model.domain.internal.collection.BasicCollectionIndexImpl;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionCreationExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionElementEmbeddedImpl;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionElementEntityImpl;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionElementExistsSelector;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionIndexEmbeddedImpl;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionIndexEntityImpl;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionIndexExistsSelector;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRemovalExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowByIndexSelector;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsDeletionExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsIndexUpdateExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsUpdateExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionSizeSelector;
import org.hibernate.metamodel.model.domain.internal.collection.FetchedTableReferenceCollectorImpl;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableCollectionRowByIndexSelector;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableCreationExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableRemovalExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableRowsDeleletionExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableRowsInsertExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.JoinTableRowsUpdateExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyCreationExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyRemovalExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyRowsDeletionExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyRowsIndexUpdateExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyRowsInsertExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.OneToManyRowsUpdateExecutor;
import org.hibernate.metamodel.model.domain.internal.collection.RootTableReferenceCollectorImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractPluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.CollectionMutabilityPlan;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.sort.SortSpecification;
import org.hibernate.sql.results.DomainResultCreationException;
import org.hibernate.sql.results.internal.domain.collection.CollectionFetchImpl;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.CollectionResultImpl;
import org.hibernate.sql.results.internal.domain.collection.DelayedCollectionFetch;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.internal.CollectionJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.jboss.logging.Logger;

public abstract class AbstractPersistentCollectionDescriptor<O, C, E>
implements PersistentCollectionDescriptor<O, C, E> {
    private static final Logger log = Logger.getLogger(AbstractPersistentCollectionDescriptor.class);
    private final SessionFactoryImplementor sessionFactory;
    private final ManagedTypeDescriptor container;
    private final PluralPersistentAttribute attribute;
    private final NavigableRole navigableRole;
    private CollectionKey foreignKeyDescriptor;
    private Navigable foreignKeyTargetNavigable;
    private CollectionJavaDescriptor<C> javaTypeDescriptor;
    private CollectionMutabilityPlan mutabilityPlan;
    private CollectionIdentifier idDescriptor;
    private CollectionElement<E> elementDescriptor;
    private CollectionIndex indexDescriptor;
    private CollectionDataAccess cacheAccess;
    private CollectionLoader collectionLoader;
    private CollectionCreationExecutor collectionCreationExecutor;
    private CollectionRemovalExecutor collectionRemovalExecutor;
    private CollectionRowsDeletionExecutor collectionRowsDeletionExecutor;
    private CollectionRowsUpdateExecutor collectionRowsUpdateExecutor;
    private CollectionCreationExecutor collectionRowsInsertExecutor;
    private CollectionRowsIndexUpdateExecutor collectionRowsIndexUpdateExecutor;
    private CollectionSizeSelector collectionSizeSelector;
    private CollectionElementExistsSelector collectionElementExistsSelector;
    private CollectionIndexExistsSelector collectionIndexExistsSelector;
    private CollectionRowByIndexSelector collectionRowByIndexSelector;
    private final String mappedBy;
    private final String sqlWhereString;
    private boolean useOwnweIdentifier;
    private final CacheEntryStructure cacheEntryStructure;
    private final String sqlAliasStem;
    private final JavaTypeDescriptor keyJavaTypeDescriptor;
    private final Set<String> spaces;
    private final int batchSize;
    private final boolean extraLazy;
    private final boolean hasOrphanDeletes;
    private final boolean inverse;
    private boolean cascadeDeleteEnabled;
    private boolean isRowInsertEnabled;
    private boolean isRowDeleteEnabled;
    private boolean fullyInitialized;
    private Table separateCollectionTable;
    private Table dmlTargetTable;
    private SortSpecification sortSpecification;
    private Class arrayElementClass;

    public AbstractPersistentCollectionDescriptor(Property pluralProperty, ManagedTypeDescriptor runtimeContainer, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        Collection collectionBinding = (Collection)pluralProperty.getValue();
        this.sessionFactory = creationContext.getSessionFactory();
        this.container = runtimeContainer;
        this.navigableRole = this.container.getNavigableRole().append(pluralProperty.getName());
        this.mutabilityPlan = this.determineMutabilityPlan(pluralProperty, creationContext);
        this.attribute = this.createAttribute(pluralProperty, runtimeContainer.getRepresentationStrategy().generatePropertyAccess(pluralProperty.getPersistentClass(), pluralProperty, runtimeContainer, this.sessionFactory.getSessionFactoryOptions().getBytecodeProvider()), creationContext);
        this.foreignKeyDescriptor = new CollectionKey(this, collectionBinding, creationContext);
        this.cacheEntryStructure = this.sessionFactory.getSessionFactoryOptions().isStructuredCacheEntriesEnabled() ? (collectionBinding.isMap() ? StructuredMapCacheEntry.INSTANCE : StructuredCollectionCacheEntry.INSTANCE) : UnstructuredCacheEntry.INSTANCE;
        this.cacheAccess = creationContext.getCollectionCacheAccess(this.getNavigableRole());
        int spacesSize = 1 + collectionBinding.getSynchronizedTables().size();
        this.spaces = new HashSet<String>(spacesSize);
        this.spaces.add(collectionBinding.getMappedTable().getNameIdentifier().render(this.sessionFactory.getServiceRegistry().getService(JdbcServices.class).getDialect()));
        this.spaces.addAll(collectionBinding.getSynchronizedTables());
        KeyValue key = collectionBinding.getKey();
        if (collectionBinding.isArray()) {
            this.arrayElementClass = ((Array)collectionBinding).getElementClass();
        }
        this.isRowDeleteEnabled = key.isNullable() && key.isUpdateable();
        this.isRowInsertEnabled = key.isUpdateable();
        this.keyJavaTypeDescriptor = key.getJavaTypeMapping().getJavaTypeDescriptor();
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(pluralProperty.getName());
        int batch = collectionBinding.getBatchSize();
        if (batch == -1) {
            batch = this.sessionFactory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.extraLazy = collectionBinding.isExtraLazy();
        this.hasOrphanDeletes = collectionBinding.hasOrphanDelete();
        this.inverse = collectionBinding.isInverse();
        this.mappedBy = collectionBinding.getMappedByProperty();
        this.sqlWhereString = StringHelper.isNotEmpty(collectionBinding.getWhere()) ? "( " + collectionBinding.getWhere() + ") " : null;
    }

    protected static CollectionJavaDescriptor findJavaTypeDescriptor(Class javaType, RuntimeModelCreationContext creationContext) {
        JavaTypeDescriptorRegistry jtdRegistry = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        CollectionJavaDescriptor descriptor = (CollectionJavaDescriptor)jtdRegistry.getDescriptor(javaType);
        if (descriptor == null) {
            throw new HibernateException("Could not locate JavaTypeDescriptor for requested Java type : " + javaType.getName());
        }
        return descriptor;
    }

    private CollectionMutabilityPlan determineMutabilityPlan(Property bootProperty, RuntimeModelCreationContext creationContext) {
        return CollectionMutabilityPlan.INSTANCE;
    }

    protected Table resolveCollectionTable(Collection collectionBinding, RuntimeModelCreationContext creationContext) {
        MappedTable mappedTable = collectionBinding.getMappedTable();
        if (mappedTable == null) {
            return null;
        }
        return creationContext.resolve(mappedTable);
    }

    @Override
    public boolean finishInitialization(Collection bootCollectionDescriptor, RuntimeModelCreationContext creationContext) {
        if (!this.fullyInitialized) {
            try {
                this.tryFinishInitialization(bootCollectionDescriptor, creationContext);
                this.fullyInitialized = true;
            }
            catch (Exception e) {
                log.debugf((Throwable)e, "#finishInitialization resulted in error [%s]", (Object)bootCollectionDescriptor);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean useOwnerIndetifier() {
        return this.useOwnweIdentifier;
    }

    protected void tryFinishInitialization(Collection bootCollectionDescriptor, RuntimeModelCreationContext creationContext) {
        String defaultSchemaNameString;
        String referencedPropertyName = bootCollectionDescriptor.getReferencedPropertyName();
        if (referencedPropertyName == null) {
            this.useOwnweIdentifier = true;
            this.foreignKeyTargetNavigable = this.getContainer().findNavigable("{id}");
        } else {
            this.foreignKeyTargetNavigable = this.getContainer().findPersistentAttribute(referencedPropertyName);
        }
        Database database = creationContext.getMetadata().getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        MappedNamespace defaultNamespace = creationContext.getMetadata().getDatabase().getDefaultNamespace();
        Identifier defaultCatalogName = defaultNamespace.getName().getCatalog();
        String defaultCatalogNameString = defaultCatalogName == null ? null : defaultNamespace.getName().getCatalog().render(dialect);
        Identifier defaultSchemaName = defaultNamespace.getName().getSchema();
        String string = defaultSchemaNameString = defaultSchemaName == null ? null : defaultNamespace.getName().getSchema().render(dialect);
        if (bootCollectionDescriptor instanceof IdentifierCollection) {
            IdentifierCollection identifierCollection = (IdentifierCollection)bootCollectionDescriptor;
            assert (identifierCollection.getIdentifier().getColumnSpan() == 1);
            Column idColumn = creationContext.getDatabaseObjectResolver().resolveColumn(identifierCollection.getIdentifier().getMappedColumns().get(0));
            IdentifierGenerator identifierGenerator = identifierCollection.getIdentifier().createIdentifierGenerator(creationContext.getIdentifierGeneratorFactory(), dialect, defaultCatalogNameString, defaultSchemaNameString, null);
            this.idDescriptor = new CollectionIdentifier(this, idColumn, identifierGenerator);
        } else {
            this.idDescriptor = null;
        }
        this.indexDescriptor = bootCollectionDescriptor instanceof IndexedCollection ? AbstractPersistentCollectionDescriptor.resolveIndexDescriptor(this, (IndexedCollection)bootCollectionDescriptor, creationContext) : null;
        if (!(bootCollectionDescriptor.getElement() instanceof OneToMany)) {
            this.separateCollectionTable = this.resolveCollectionTable(bootCollectionDescriptor, creationContext);
        }
        this.elementDescriptor = AbstractPersistentCollectionDescriptor.resolveElementDescriptor(this, bootCollectionDescriptor, this.separateCollectionTable, creationContext);
        if (!this.isOneToMany()) {
            this.isRowDeleteEnabled = true;
            this.isRowInsertEnabled = true;
        } else {
            this.cascadeDeleteEnabled = bootCollectionDescriptor.getKey().isCascadeDeleteEnabled() && creationContext.getSessionFactory().getDialect().supportsCascadeDelete();
        }
        this.javaTypeDescriptor = (CollectionJavaDescriptor)bootCollectionDescriptor.getJavaTypeMapping().getJavaTypeDescriptor();
        this.collectionLoader = this.resolveCollectionLoader(bootCollectionDescriptor, creationContext);
        this.dmlTargetTable = this.resolveDmlTargetTable(this.separateCollectionTable, bootCollectionDescriptor, creationContext);
    }

    private static <J, T extends Type<J>> CollectionIndex<J> resolveIndexDescriptor(PersistentCollectionDescriptor descriptor, IndexedCollection collectionBinding, RuntimeModelCreationContext creationContext) {
        Value indexValueMapping = collectionBinding.getIndex();
        if (indexValueMapping instanceof Any) {
            throw new NotYetImplementedException();
        }
        if (indexValueMapping instanceof BasicValueMapping) {
            return new BasicCollectionIndexImpl(descriptor, collectionBinding, creationContext);
        }
        if (indexValueMapping instanceof EmbeddedValueMapping) {
            return new CollectionIndexEmbeddedImpl(descriptor, collectionBinding, creationContext);
        }
        if (indexValueMapping instanceof OneToMany || indexValueMapping instanceof ManyToOne) {
            return new CollectionIndexEntityImpl(descriptor, collectionBinding, creationContext);
        }
        throw new IllegalArgumentException("Could not determine proper CollectionIndex descriptor to generate.  Unrecognized ValueMapping : " + indexValueMapping);
    }

    private static CollectionElement resolveElementDescriptor(AbstractPersistentCollectionDescriptor descriptor, Collection bootCollectionDescriptor, Table separateCollectionTable, RuntimeModelCreationContext creationContext) {
        if (bootCollectionDescriptor.getElement() instanceof Any) {
            throw new NotYetImplementedException();
        }
        if (bootCollectionDescriptor.getElement() instanceof BasicValueMapping) {
            return new BasicCollectionElementImpl(descriptor, bootCollectionDescriptor, creationContext);
        }
        if (bootCollectionDescriptor.getElement() instanceof EmbeddedValueMapping) {
            return new CollectionElementEmbeddedImpl(descriptor, bootCollectionDescriptor, creationContext);
        }
        if (bootCollectionDescriptor.getElement() instanceof ToOne) {
            return new CollectionElementEntityImpl(descriptor, bootCollectionDescriptor, CollectionElement.ElementClassification.MANY_TO_MANY, creationContext);
        }
        if (bootCollectionDescriptor.getElement() instanceof OneToMany) {
            return new CollectionElementEntityImpl(descriptor, bootCollectionDescriptor, CollectionElement.ElementClassification.ONE_TO_MANY, creationContext);
        }
        throw new IllegalArgumentException("Could not determine proper CollectionElement descriptor to generate.  Unrecognized ValueMapping : " + bootCollectionDescriptor.getElement());
    }

    private CollectionLoader resolveCollectionLoader(Collection bootCollectionDescriptor, RuntimeModelCreationContext creationContext) {
        if (StringHelper.isNotEmpty(bootCollectionDescriptor.getLoaderName())) {
            throw new NotYetImplementedFor6Exception();
        }
        return new CollectionLoaderImpl(this.getDescribedAttribute(), this.getSessionFactory());
    }

    protected Table resolveDmlTargetTable(Table separateCollectionTable, Collection collectionBinding, RuntimeModelCreationContext creationContext) {
        if (separateCollectionTable != null) {
            return separateCollectionTable;
        }
        assert (this.getElementDescriptor().getClassification() == CollectionElement.ElementClassification.ONE_TO_MANY);
        Table table = this.getElementDescriptor().getPrimaryDmlTable();
        if (table == null) {
            throw new IllegalStateException("Could not determine DML target table for collection: " + this);
        }
        return table;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public JavaTypeDescriptor getKeyJavaTypeDescriptor() {
        return this.keyJavaTypeDescriptor;
    }

    @Override
    public Set<String> getCollectionSpaces() {
        return this.spaces;
    }

    @Override
    public void initialize(Object loadedKey, SharedSessionContractImplementor session) {
        this.getLoader().load(loadedKey, LockOptions.READ, session);
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public CollectionSemantics<C> getSemantics() {
        return ((CollectionJavaDescriptor)this.getJavaTypeDescriptor()).getSemantics();
    }

    @Override
    public TableGroup createRootTableGroup(NavigablePath navigablePath, String explicitSourceAlias, JoinType tableReferenceJoinType, LockMode lockMode, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
        RootTableReferenceCollectorImpl collector = new RootTableReferenceCollectorImpl(navigablePath, this, explicitSourceAlias, lockMode);
        this.applyTableReferenceJoins(null, tableReferenceJoinType, sqlAliasBase, collector);
        return collector.generateTableGroup();
    }

    @Override
    public PersistentCollectionDescriptor getCollectionDescriptor() {
        return this;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, JoinType joinType, LockMode lockMode, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
        FetchedTableReferenceCollectorImpl joinCollector = new FetchedTableReferenceCollectorImpl(navigablePath, this, lhs, explicitSourceAlias, lockMode);
        this.applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
        if (this.getDescribedAttribute().isNullable() && JoinType.INNER.equals((Object)joinType)) {
            joinType = JoinType.LEFT;
        }
        return joinCollector.generateTableGroup(joinType);
    }

    @Override
    public EntityTypeDescriptor findEntityOwnerDescriptor() {
        return this.findFirstEntityDescriptor();
    }

    protected abstract CollectionInitializerProducer createInitializerProducer(NavigablePath var1, FetchParent var2, boolean var3, String var4, LockMode var5, DomainResultCreationState var6);

    protected abstract AbstractPluralPersistentAttribute createAttribute(Property var1, PropertyAccess var2, RuntimeModelCreationContext var3);

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.getDescribedAttribute().getMappedFetchStrategy();
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        LockMode lockMode = creationState.determineLockMode(resultVariable);
        return new CollectionResultImpl(this.attribute, navigablePath, resultVariable, lockMode, this.getCollectionKeyDescriptor().createDomainResult(navigablePath.append("{key}"), null, creationState), this.createInitializerProducer(navigablePath, null, true, resultVariable, lockMode, creationState));
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        if (!this.isArray() && fetchTiming == FetchTiming.DELAYED) {
            return this.generateDelayedFetch(fetchParent, resultVariable, creationState);
        }
        return this.generateImmediateFetch(fetchParent, resultVariable, lockMode, creationState);
    }

    private boolean isArray() {
        return this.getCollectionDescriptor().getCollectionClassification() == CollectionClassification.ARRAY;
    }

    protected Fetch generateDelayedFetch(FetchParent fetchParent, String resultVariable, DomainResultCreationState creationState) {
        return new DelayedCollectionFetch(fetchParent, this.getDescribedAttribute(), resultVariable, this.getCollectionKeyDescriptor().createContainerResult(creationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), creationState));
    }

    private Fetch generateImmediateFetch(FetchParent fetchParent, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        NavigablePath navigablePath = fetchParent.getNavigablePath().append(this.getNavigableName());
        TableGroup parentTableGroup = creationState.getFromClauseAccess().getTableGroup(navigablePath.getParent());
        TableGroup collectionTableGroup = creationState.getFromClauseAccess().resolveTableGroup(navigablePath, np -> {
            if (parentTableGroup == null) {
                throw new DomainResultCreationException("Could not locate LHS TableGroup for collection fetch : " + navigablePath);
            }
            creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(navigablePath, parentTableGroup, resultVariable, JoinType.INNER, lockMode, creationState.getSqlAstCreationState());
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        return CollectionFetchImpl.create(navigablePath, collectionTableGroup, parentTableGroup, fetchParent, this.getDescribedAttribute(), resultVariable, lockMode, this.createInitializerProducer(navigablePath, fetchParent, true, resultVariable, lockMode, creationState), creationState);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        if (this.getIndexDescriptor() instanceof Fetchable) {
            fetchableConsumer.accept((Fetchable)((Object)this.getIndexDescriptor()));
        }
        if (this.getElementDescriptor() instanceof Fetchable) {
            fetchableConsumer.accept((Fetchable)((Object)this.getElementDescriptor()));
        }
    }

    @Override
    public ManagedTypeDescriptor getContainer() {
        return this.container;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String asLoggableText() {
        return String.format(Locale.ROOT, "%s(%s)", PersistentCollectionDescriptor.class.getSimpleName(), this.getNavigableRole().getFullPath());
    }

    @Override
    public PluralPersistentAttribute getDescribedAttribute() {
        return this.attribute;
    }

    @Override
    public CollectionMutabilityPlan<C> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public CollectionKey getCollectionKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    @Override
    public Navigable getForeignKeyTargetNavigable() {
        return this.foreignKeyTargetNavigable;
    }

    @Override
    public boolean contains(Object collection, E childObject) {
        return false;
    }

    @Override
    public Class getElementClass() {
        return this.arrayElementClass;
    }

    @Override
    public CollectionIdentifier getIdDescriptor() {
        return this.idDescriptor;
    }

    @Override
    public CollectionElement<E> getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionIndex getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public CollectionLoader getLoader() {
        return this.collectionLoader;
    }

    @Override
    public Table getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    @Override
    public boolean hasOrphanDelete() {
        return this.hasOrphanDeletes;
    }

    @Override
    public boolean isOneToMany() {
        return this.getElementDescriptor().getClassification() == CollectionElement.ElementClassification.ONE_TO_MANY;
    }

    @Override
    public boolean isExtraLazy() {
        return this.extraLazy;
    }

    @Override
    public boolean isDirty(Object old, Object value, SharedSessionContractImplementor session) {
        return this.getElementDescriptor().isDirty(old, value, session);
    }

    @Override
    public int getSize(Object loadedKey, SharedSessionContractImplementor session) {
        if (this.collectionSizeSelector == null) {
            this.collectionSizeSelector = new CollectionSizeSelector(this, this.dmlTargetTable, this.sqlWhereString, this.sessionFactory);
        }
        int baseIndex = this.getIndexDescriptor() != null ? this.getIndexDescriptor().getBaseIndex() : 0;
        return this.collectionSizeSelector.execute(loadedKey, session) - baseIndex;
    }

    @Override
    public Boolean indexExists(Object loadedKey, Object index, SharedSessionContractImplementor session) {
        if (this.collectionIndexExistsSelector == null) {
            this.collectionIndexExistsSelector = new CollectionIndexExistsSelector(this, this.dmlTargetTable, this.sqlWhereString, this.sessionFactory);
        }
        return this.collectionIndexExistsSelector.indexExists(loadedKey, this.incrementIndexByBase(index), session);
    }

    protected Object incrementIndexByBase(Object index) {
        int baseIndex = this.getIndexDescriptor().getBaseIndex();
        if (baseIndex != 0) {
            index = (Integer)index + baseIndex;
        }
        return index;
    }

    @Override
    public Boolean elementExists(Object loadedKey, Object element, PersistentCollection collection, SharedSessionContractImplementor session) {
        if (this.collectionElementExistsSelector == null) {
            this.collectionElementExistsSelector = new CollectionElementExistsSelector(this, this.dmlTargetTable, this.sqlWhereString, this.sessionFactory);
        }
        return this.collectionElementExistsSelector.elementExists(loadedKey, element, collection, session);
    }

    @Override
    public Object getElementByIndex(Object loadedKey, Object index, SharedSessionContractImplementor session, Object owner) {
        if (this.collectionRowByIndexSelector == null) {
            this.collectionRowByIndexSelector = this.generateRowByIndexSelector();
        }
        return this.collectionRowByIndexSelector.execute(loadedKey, this.incrementIndexByBase(index), session);
    }

    CollectionRowByIndexSelector generateRowByIndexSelector() {
        if (this.isOneToMany()) {
            throw new NotYetImplementedFor6Exception();
        }
        if (!this.hasIndex()) {
            return CollectionRowByIndexSelector.NO_OP;
        }
        return new JoinTableCollectionRowByIndexSelector(this, this.dmlTargetTable, this.sqlWhereString, this.sessionFactory);
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    @Override
    public CollectionDataAccess getCacheAccess() {
        return this.cacheAccess;
    }

    @Override
    public String getMappedByProperty() {
        return this.mappedBy;
    }

    @Override
    public CollectionJavaDescriptor<C> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public boolean isAffectedByEnabledFilters(SharedSessionContractImplementor session) {
        return false;
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        if (this.separateCollectionTable != null) {
            TableReference joinedTableReference = new TableReference(this.separateCollectionTable, sqlAliasBase.generateNewAlias(), false);
            if (joinCollector.getPrimaryTableReference() != null) {
                joinCollector.addSecondaryReference(new TableReferenceJoin(JoinType.INNER, joinedTableReference, this.makePredicate(joinedTableReference, joinCollector.getPrimaryTableReference())));
            } else {
                joinCollector.addPrimaryReference(joinedTableReference);
            }
            lhs = joinedTableReference;
        }
        if (this.getIndexDescriptor() != null) {
            this.getIndexDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
        }
        this.getElementDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
    }

    private Predicate makePredicate(ColumnReferenceQualifier lhs, TableReference rhs) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        for (ForeignKey foreignKey : this.foreignKeyDescriptor.getJoinForeignKey().getReferringTable().getForeignKeys()) {
            if (!foreignKey.getTargetTable().equals(rhs.getTable())) continue;
            for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : foreignKey.getColumnMappings().getColumnMappings()) {
                ColumnReference referringColumnReference = lhs.resolveColumnReference(columnMapping.getReferringColumn());
                ColumnReference targetColumnReference = rhs.resolveColumnReference(columnMapping.getTargetColumn());
                conjunction.add(new ComparisonPredicate(referringColumnReference, ComparisonOperator.EQUAL, targetColumnReference));
            }
        }
        return conjunction;
    }

    @Override
    public void deleteRows(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (this.collectionRowsDeletionExecutor == null) {
            this.collectionRowsDeletionExecutor = this.generateCollectionRowsDeletionExecutor();
        }
        if (log.isDebugEnabled()) {
            log.debugf("Deleting rows of collection: %s", (Object)MessageHelper.collectionInfoString((PersistentCollectionDescriptor)this, collection, key, session));
        }
        this.collectionRowsDeletionExecutor.execute(collection, key, session);
    }

    private CollectionRowsDeletionExecutor generateCollectionRowsDeletionExecutor() {
        if (this.isInverse() || !this.isRowDeleteEnabled()) {
            return CollectionRowsDeletionExecutor.NO_OP;
        }
        if (this.isOneToMany()) {
            return new OneToManyRowsDeletionExecutor(this, this.sessionFactory, this.dmlTargetTable, this.hasIndex(), this.indexContainsFormula());
        }
        return new JoinTableRowsDeleletionExecutor(this, this.sessionFactory, this.hasIndex() && !this.indexContainsFormula());
    }

    @Override
    public void insertRows(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (this.collectionRowsInsertExecutor == null) {
            this.collectionRowsInsertExecutor = this.generateCollectionRowsInsertExecutor();
        }
        if (log.isDebugEnabled()) {
            log.debugf("Inserting rows of collection: %s", (Object)MessageHelper.collectionInfoString((PersistentCollectionDescriptor)this, collection, key, session));
        }
        this.collectionRowsInsertExecutor.execute(collection, key, session);
        this.writeIndex(collection, key, false, true, session);
    }

    private CollectionCreationExecutor generateCollectionRowsInsertExecutor() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            return AbstractCreationExecutor.NO_OP;
        }
        if (this.isOneToMany()) {
            return new OneToManyRowsInsertExecutor(this, this.dmlTargetTable, this.getSessionFactory());
        }
        return new JoinTableRowsInsertExecutor(this, this.dmlTargetTable, this.getSessionFactory());
    }

    @Override
    public void updateRows(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (!this.isInverse() && collection.isRowUpdatePossible()) {
            if (this.collectionRowsUpdateExecutor == null) {
                this.collectionRowsUpdateExecutor = this.generateCollectionRowsUpdateExecutor();
            }
            if (log.isDebugEnabled()) {
                log.debugf("Updating rows of collection: %s", (Object)MessageHelper.collectionInfoString((PersistentCollectionDescriptor)this, collection, key, session));
            }
            this.collectionRowsUpdateExecutor.execute(collection, key, session);
        }
    }

    protected CollectionRowsUpdateExecutor generateCollectionRowsUpdateExecutor() {
        if (this.isInverse()) {
            return CollectionRowsUpdateExecutor.NO_OP;
        }
        if (this.isOneToMany()) {
            return new OneToManyRowsUpdateExecutor(this, this.dmlTargetTable, this.isRowDeleteEnabled, this.isRowInsertEnabled, this.hasIndex(), this.indexContainsFormula(), this.sessionFactory);
        }
        return new JoinTableRowsUpdateExecutor(this, this.dmlTargetTable, this.hasIndex(), this.indexContainsFormula(), this.sessionFactory);
    }

    private CollectionRowsIndexUpdateExecutor generateCollectionRowsIndexExecutor() {
        if (!(this.isOneToMany() && this.isInverse() && this.hasIndex() && !this.indexContainsFormula() && this.isIndexSettable())) {
            return CollectionRowsIndexUpdateExecutor.NO_OP;
        }
        return new OneToManyRowsIndexUpdateExecutor(this, this.dmlTargetTable, this.sessionFactory);
    }

    protected boolean hasIndex() {
        return false;
    }

    protected boolean isIndexSettable() {
        return this.getIndexDescriptor() != null && this.getIndexDescriptor().isSettable();
    }

    protected boolean indexContainsFormula() {
        return false;
    }

    @Override
    public void recreate(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (this.collectionCreationExecutor == null) {
            this.collectionCreationExecutor = this.generateCollectionCreationExecutor();
        }
        if (log.isDebugEnabled()) {
            log.debugf("Inserting collection: %s", (Object)LoggingHelper.toLoggableString(this.getNavigableRole(), key));
        }
        this.collectionCreationExecutor.execute(collection, key, session);
        this.writeIndex(collection, key, false, true, session);
    }

    private CollectionCreationExecutor generateCollectionCreationExecutor() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            return CollectionCreationExecutor.NO_OP;
        }
        if (this.isOneToMany()) {
            return new OneToManyCreationExecutor(this, this.dmlTargetTable, this.getSessionFactory());
        }
        return new JoinTableCreationExecutor(this, this.dmlTargetTable, this.getSessionFactory());
    }

    protected boolean isRowInsertEnabled() {
        return this.isRowInsertEnabled;
    }

    @Override
    public void remove(Object key, SharedSessionContractImplementor session) {
        log.tracef("Starting #remove(%s)", key);
        if (this.collectionRemovalExecutor == null) {
            this.collectionRemovalExecutor = this.generateCollectionRemovalExecutor();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting collection: " + LoggingHelper.toLoggableString(this.getNavigableRole(), key)));
        }
        this.collectionRemovalExecutor.execute(key, session);
    }

    private CollectionRemovalExecutor generateCollectionRemovalExecutor() {
        if (this.isInverse()) {
            return (key, session) -> log.tracef("Skipping remove for inverse collection", new Object[0]);
        }
        if (!this.isRowDeleteEnabled()) {
            return (key, session) -> log.tracef("Skipping remove for collection - row deletion disabled", new Object[0]);
        }
        if (this.isOneToMany()) {
            return new OneToManyRemovalExecutor(this, this.dmlTargetTable, this.sessionFactory);
        }
        return new JoinTableRemovalExecutor(this, this.sessionFactory);
    }

    protected boolean isRowDeleteEnabled() {
        return this.isRowDeleteEnabled;
    }

    @Override
    public Object getKeyOfOwner(Object owner, SessionImplementor session) {
        EntityEntry entityEntry = session.getPersistenceContext().getEntry(owner);
        if (entityEntry == null) {
            return null;
        }
        Navigable foreignKeyTargetNavigable = this.getForeignKeyTargetNavigable();
        if (foreignKeyTargetNavigable == null) {
            return entityEntry.getId();
        }
        if (foreignKeyTargetNavigable instanceof EntityIdentifier) {
            return this.getContainer().findFirstEntityDescriptor().getIdentifier(owner);
        }
        return ((SingularPersistentAttribute)foreignKeyTargetNavigable).getPropertyAccess().getGetter().get(owner);
    }

    @Override
    public void processQueuedOps(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (collection.hasQueuedOperations() && this.isOneToMany()) {
            this.doProcessQueuedOps(collection, key, session);
            this.writeIndex(collection, key, true, false, session);
        }
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.TO_PARENT;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    private void writeIndex(PersistentCollection collection, Object key, boolean queuedOperations, boolean resetIndex, SharedSessionContractImplementor session) {
        if (this.collectionRowsIndexUpdateExecutor == null) {
            this.collectionRowsIndexUpdateExecutor = this.generateCollectionRowsIndexExecutor();
        }
        this.collectionRowsIndexUpdateExecutor.execute(collection, key, queuedOperations, resetIndex, session);
    }

    protected abstract void doProcessQueuedOps(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);
}

