/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.AbstractPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEmbedded;
import org.hibernate.metamodel.model.domain.spi.CollectionMutabilityPlan;
import org.hibernate.metamodel.model.domain.spi.DomainModelHelper;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierSimple;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.internal.CollectionJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractPluralPersistentAttribute<O, C, E>
extends AbstractPersistentAttribute<O, C>
implements PluralPersistentAttribute<O, C, E> {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AbstractPluralPersistentAttribute.class);
    private static final Object NOT_NULL_COLLECTION = new MarkerObject("NOT NULL COLLECTION");
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final FetchStrategy fetchStrategy;
    private CascadeStyle cascadeStyle;
    private final boolean isNullable;
    private final String cascade;
    private int stateArrayPosition;

    public AbstractPluralPersistentAttribute(PersistentCollectionDescriptor collectionDescriptor, Property bootProperty, PropertyAccess propertyAccess, RuntimeModelCreationContext creationContext) {
        super(collectionDescriptor.getContainer(), bootProperty, propertyAccess);
        org.hibernate.mapping.Collection bootCollectionDescriptor = (org.hibernate.mapping.Collection)bootProperty.getValue();
        this.collectionDescriptor = collectionDescriptor;
        creationContext.registerCollectionDescriptor(collectionDescriptor, bootCollectionDescriptor);
        this.isNullable = bootCollectionDescriptor.isNullable();
        this.fetchStrategy = DomainModelHelper.determineFetchStrategy(bootCollectionDescriptor);
        this.cascade = bootProperty.getCascade();
    }

    @Override
    public PersistentCollectionDescriptor getPersistentCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        if (this.cascadeStyle == null) {
            this.cascadeStyle = this.collectionDescriptor.getElementDescriptor() instanceof CollectionElementEmbedded ? this.elementCascadeStyle((CollectionElementEmbedded)this.collectionDescriptor.getElementDescriptor()) : DomainModelHelper.determineCascadeStyle(this.cascade);
        }
        return this.cascadeStyle;
    }

    private CascadeStyle elementCascadeStyle(CollectionElementEmbedded element) {
        EmbeddedTypeDescriptor embeddedDescriptor = element.getEmbeddedDescriptor();
        for (StateArrayContributor contributor : embeddedDescriptor.getStateArrayContributors()) {
            if (contributor.getCascadeStyle() == CascadeStyles.NONE) continue;
            return CascadeStyles.ALL;
        }
        return DomainModelHelper.determineCascadeStyle(this.cascade);
    }

    @Override
    public void collectNonNullableTransientEntities(Object value, ForeignKeys.Nullifier nullifier, NonNullableTransientDependencies nonNullableTransientEntities, SharedSessionContractImplementor session) {
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    @Override
    public ManagedTypeDescriptor getContainer() {
        return this.getPersistentCollectionDescriptor().getContainer();
    }

    @Override
    public SimpleTypeDescriptor getElementType() {
        return this.collectionDescriptor.getElementDescriptor().getDomainTypeDescriptor();
    }

    @Override
    public SimpleTypeDescriptor<?> getValueGraphType() {
        return this.getElementType();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return this.collectionDescriptor.getIndexDescriptor() == null ? null : this.collectionDescriptor.getIndexDescriptor().getDomainTypeDescriptor();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return false;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        CollectionDomainType.Element collectionElement = this.getPersistentCollectionDescriptor().getElementDescriptor();
        switch (collectionElement.getClassification()) {
            case EMBEDDABLE: 
            case BASIC: {
                return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
            }
            case MANY_TO_MANY: {
                return Attribute.PersistentAttributeType.MANY_TO_MANY;
            }
            case ONE_TO_MANY: {
                return Attribute.PersistentAttributeType.ONE_TO_MANY;
            }
        }
        throw new NotYetImplementedFor6Exception();
    }

    public boolean isAssociation() {
        return this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY;
    }

    public boolean isCollection() {
        return true;
    }

    public Class getBindableJavaType() {
        return this.getPersistentCollectionDescriptor().getElementDescriptor().getJavaType();
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public void visitColumns(BiConsumer action, Clause clause, TypeConfiguration typeConfiguration) {
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public void setStateArrayPosition(int position) {
        this.stateArrayPosition = position;
    }

    public CollectionMutabilityPlan getMutabilityPlan() {
        return this.getCollectionDescriptor().getMutabilityPlan();
    }

    @Override
    public Navigable findNavigable(String navigableName) {
        return this.getPersistentCollectionDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getPersistentCollectionDescriptor().visitNavigables(visitor);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.collectionDescriptor.getNavigableRole();
    }

    @Override
    public String asLoggableText() {
        return this.toString();
    }

    @Override
    public CollectionJavaDescriptor getJavaTypeDescriptor() {
        return this.collectionDescriptor.getJavaTypeDescriptor();
    }

    @Override
    public boolean isIncludedInDirtyChecking() {
        return true;
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        return this.getPersistentCollectionDescriptor().createDomainResult(navigablePath, resultVariable, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return this.getPersistentCollectionDescriptor().generateFetch(fetchParent, fetchTiming, selected, lockMode, resultVariable, creationState);
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public List<Column> getColumns() {
        return Collections.emptyList();
    }

    @Override
    public Object hydrate(Object jdbcValues, SharedSessionContractImplementor session) {
        if (jdbcValues == null) {
            return null;
        }
        return NOT_NULL_COLLECTION;
    }

    @Override
    public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        PersistentCollection collection;
        IdentifiableTypeDescriptor ownerDescriptor = (IdentifiableTypeDescriptor)this.getContainer();
        EntityIdentifierSimple identifierDescriptor = (EntityIdentifierSimple)ownerDescriptor.getHierarchy().getIdentifierDescriptor();
        Object key = identifierDescriptor.asAttribute(identifierDescriptor.getJavaType()).getPropertyAccess().getGetter().get(containerInstance);
        PersistentCollectionDescriptor collectionDescriptor = this.getPersistentCollectionDescriptor();
        CollectionKey collectionKey = new CollectionKey(collectionDescriptor, key);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        LoadingCollectionEntry loadingCollectionEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
        PersistentCollection persistentCollection = collection = loadingCollectionEntry == null ? null : loadingCollectionEntry.getCollectionInstance();
        if (collection == null) {
            collection = persistenceContext.useUnownedCollection(collectionKey);
            if (collection == null && (collection = persistenceContext.getCollection(collectionKey)) == null) {
                collection = collectionDescriptor.instantiateWrapper(session, key);
                collection.setOwner(containerInstance);
                persistenceContext.addUninitializedCollection(collectionDescriptor, collection, key);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Created collection wrapper: %s", MessageHelper.collectionInfoString(collectionDescriptor, collection, key, session));
            }
        }
        collection.setOwner(containerInstance);
        collection.setCurrentSession(session);
        return collection.getValue();
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        return NOT_NULL_COLLECTION;
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        if (value != null && value != NOT_NULL_COLLECTION) {
            this.getPersistentCollectionDescriptor().getElementDescriptor().dehydrate(value, jdbcValueCollector, clause, session);
        }
    }

    @Override
    public boolean isDirty(Object originalValue, Object currentValue, SharedSessionContractImplementor session) {
        return !this.getJavaTypeDescriptor().areEqual(originalValue, currentValue);
    }

    @Override
    public void visitFetchables(Consumer consumer) {
        this.getPersistentCollectionDescriptor().visitFetchables(consumer);
    }

    public String toString() {
        return "PluralPersistentAttribute(" + this.getNavigableRole() + ")";
    }

    @Override
    public DomainType getAttributeType() {
        return null;
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return this.getPersistentCollectionDescriptor().getForeignKeyDirection();
    }

    @Override
    public Object replace(C originalValue, C targetValue, Object owner, Map copyCache, SessionImplementor session) {
        if (originalValue == null) {
            return null;
        }
        if (!Hibernate.isInitialized(originalValue)) {
            if (((PersistentCollection)originalValue).hasQueuedOperations()) {
                if (originalValue == targetValue) {
                    AbstractPersistentCollection pc = (AbstractPersistentCollection)originalValue;
                    pc.replaceQueuedOperationValues(this.getCollectionDescriptor(), copyCache);
                } else {
                    log.ignoreQueuedOperationsOnMerge(MessageHelper.collectionInfoString(this.collectionDescriptor, (PersistentCollection)targetValue, ((PersistentCollection)targetValue).getKey(), (SharedSessionContractImplementor)session));
                }
            }
            return targetValue;
        }
        C result = targetValue == null || targetValue == originalValue || targetValue == LazyPropertyInitializer.UNFETCHED_PROPERTY ? this.instantiateResult(originalValue) : targetValue;
        result = this.replaceElements(originalValue, result, owner, copyCache, session);
        if (originalValue == targetValue) {
            boolean wasClean = PersistentCollection.class.isInstance(targetValue) && !((PersistentCollection)targetValue).isDirty();
            this.replaceElements(result, targetValue, owner, copyCache, session);
            if (wasClean) {
                ((PersistentCollection)targetValue).clearDirty();
            }
            result = targetValue;
        }
        return result;
    }

    @Override
    public Object replace(C originalValue, C targetValue, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection, SessionImplementor session) {
        boolean include = this.isAssociation() ? this.getForeignKeyDirection() == foreignKeyDirection : ForeignKeyDirection.FROM_PARENT == foreignKeyDirection;
        return include ? this.replace(originalValue, targetValue, owner, copyCache, session) : targetValue;
    }

    protected C instantiateResult(C originalValue) {
        return this.collectionDescriptor.instantiateRaw(-1);
    }

    protected C replaceElements(C originalValue, C targetValue, Object owner, Map copyCache, SessionImplementor session) {
        Collection result = (Collection)targetValue;
        result.clear();
        CollectionDomainType.Element elementDescriptor = this.collectionDescriptor.getElementDescriptor();
        Iterator iter = ((Collection)originalValue).iterator();
        while (iter.hasNext()) {
            result.add(elementDescriptor.replace(iter.next(), null, owner, copyCache, session));
        }
        if (originalValue instanceof PersistentCollection && targetValue instanceof PersistentCollection) {
            PersistentCollection originalCollection = (PersistentCollection)originalValue;
            PersistentCollection targetCollection = (PersistentCollection)targetValue;
            this.preserveSnapshot(originalCollection, targetCollection, owner, copyCache, session);
            if (!originalCollection.isDirty()) {
                targetCollection.clearDirty();
            }
        }
        return (C)result;
    }

    /*
     * WARNING - void declaration
     */
    protected void preserveSnapshot(PersistentCollection originalCollection, PersistentCollection targetCollection, Object owner, Map copyCache, SessionImplementor session) {
        Serializable result;
        Serializable originalValue = originalCollection.getStoredSnapshot();
        Serializable targetValue = targetCollection.getStoredSnapshot();
        CollectionDomainType.Element elementDescriptor = this.getCollectionDescriptor().getElementDescriptor();
        if (originalValue instanceof List) {
            result = new ArrayList(((List)((Object)originalValue)).size());
            for (Object e : (List)((Object)originalValue)) {
                ((List)((Object)result)).add(elementDescriptor.replace(e, null, owner, copyCache, session));
            }
        } else if (originalValue instanceof Map) {
            result = originalValue instanceof SortedMap ? new TreeMap(((SortedMap)((Object)originalValue)).comparator()) : new HashMap(CollectionHelper.determineProperSizing(((Map)((Object)originalValue)).size()), 0.75f);
            for (Map.Entry entry : ((Map)((Object)originalValue)).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object resultSnapshotValue = targetValue == null ? null : (Object)((Map)((Object)targetValue)).get(key);
                Object newValue = elementDescriptor.replace(value, resultSnapshotValue, owner, copyCache, session);
                if (key == value) {
                    ((Map)((Object)result)).put(newValue, newValue);
                    continue;
                }
                ((Map)((Object)result)).put(key, newValue);
            }
        } else if (originalValue instanceof Object[]) {
            void var11_14;
            Object[] arr = (Object[])originalValue;
            boolean bl = false;
            while (var11_14 < arr.length) {
                arr[var11_14] = elementDescriptor.replace(arr[var11_14], null, owner, copyCache, session);
                ++var11_14;
            }
            result = originalValue;
        } else {
            result = targetValue;
        }
        CollectionEntry entry = session.getPersistenceContext().getCollectionEntry(targetCollection);
        if (entry != null) {
            entry.resetStoredSnapshot(targetCollection, result);
        }
    }
}

