/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractTableReferenceCollector
implements TableReferenceJoinCollector {
    private TableReference primaryTableReference;
    private List<TableReferenceJoin> tableReferenceJoins;

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableReferenceJoins == null ? Collections.emptyList() : this.tableReferenceJoins;
    }

    @Override
    public void addPrimaryReference(TableReference primaryReference) {
        if (this.primaryTableReference != null) {
            throw new IllegalStateException("Not expecting primary TableReference");
        }
        this.primaryTableReference = primaryReference;
    }

    @Override
    public void addSecondaryReference(TableReferenceJoin secondaryReference) {
        if (this.tableReferenceJoins == null) {
            this.tableReferenceJoins = new ArrayList<TableReferenceJoin>();
        }
        this.tableReferenceJoins.add(secondaryReference);
    }

    public TableReference resolveTableReference(Table table, Function<Table, TableReference> creator, BiFunction<TableReference, Table, TableReferenceJoin> joinCreator) {
        if (this.primaryTableReference == null) {
            this.primaryTableReference = creator.apply(table);
            return this.primaryTableReference;
        }
        if (table.equals(this.primaryTableReference.getTable())) {
            return this.primaryTableReference;
        }
        if (this.tableReferenceJoins == null) {
            this.tableReferenceJoins = new ArrayList<TableReferenceJoin>();
            return this.createJoin(table, joinCreator);
        }
        TableReferenceJoin existing = null;
        for (TableReferenceJoin tableReferenceJoin : this.tableReferenceJoins) {
            if (!table.equals(tableReferenceJoin.getJoinedTableReference().getTable())) continue;
            existing = tableReferenceJoin;
            break;
        }
        if (existing != null) {
            return existing.getJoinedTableReference();
        }
        return this.createJoin(table, joinCreator);
    }

    private TableReference createJoin(Table table, BiFunction<TableReference, Table, TableReferenceJoin> joinCreator) {
        TableReferenceJoin join = joinCreator.apply(this.primaryTableReference, table);
        this.tableReferenceJoins.add(join);
        return join.getJoinedTableReference();
    }
}

