/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Locale;
import java.util.function.BiConsumer;
import javax.persistence.metamodel.Type;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.spi.BasicTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.SqlTreeException;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.DomainResultCreationException;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public interface BasicValuedNavigable<J>
extends BasicValuedExpressableType<J>,
Navigable<J>,
SimpleTypeDescriptor<J>,
BasicTypeDescriptor<J> {
    @Override
    default public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Column getBoundColumn();

    public BasicValueMapper<J> getValueMapper();

    @Override
    default public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getValueMapper().getDomainJavaDescriptor();
    }

    @Override
    default public SqlExpressableType getSqlExpressableType() {
        return this.getValueMapper().getSqlExpressableType();
    }

    @Override
    default public Object unresolve(Object value, SharedSessionContractImplementor session) {
        if (this.getValueMapper().getValueConverter() != null) {
            value = this.getValueMapper().getValueConverter().toRelationalValue(value, session);
        }
        return value;
    }

    @Override
    default public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        if (this.getBoundColumn() != null) {
            action.accept(this.getBoundColumn().getExpressableType(), this.getBoundColumn());
        }
    }

    @Override
    default public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        Column boundColumn = this.getBoundColumn();
        if (boundColumn instanceof PhysicalColumn) {
            jdbcValueCollector.collect(value, boundColumn.getExpressableType(), boundColumn);
        }
    }

    @Override
    default public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        return new SqmBasicValuedSimplePath(lhs.getNavigablePath().append(this.getNavigableName()), this, lhs);
    }

    @Override
    default public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        NavigablePath parentNavigablePath = navigablePath.getParent();
        if (parentNavigablePath == null) {
            throw new DomainResultCreationException("Parent NavigablePath cannot be null for basic path");
        }
        TableGroup tableGroup = creationState.getFromClauseAccess().findTableGroup(parentNavigablePath);
        if (tableGroup == null) {
            throw new SqlTreeException(String.format(Locale.ROOT, "Could not locate TableGroup for basic path : %s -> %s", navigablePath, this));
        }
        SqlExpressionResolver resolver = creationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = resolver.resolveSqlSelection(resolver.resolveSqlExpression(tableGroup, this.getBoundColumn()), (BasicJavaDescriptor)this.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
        BasicValueConverter valueConverter = null;
        if (this instanceof ConvertibleNavigable) {
            valueConverter = ((ConvertibleNavigable)((Object)this)).getValueConverter();
        }
        return new BasicResultImpl(resultVariable, sqlSelection, this.getBoundColumn().getExpressableType(), valueConverter);
    }
}

