/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class ByteVersionSupport
implements VersionSupport<Byte> {
    public static final ByteVersionSupport INSTANCE = new ByteVersionSupport();
    private static final Byte ZERO = 0;

    @Override
    public Byte seed(SharedSessionContractImplementor session) {
        return ZERO;
    }

    @Override
    public Byte next(Byte current, SharedSessionContractImplementor session) {
        return (byte)(current + 1);
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.BYTE.toLoggableString(value);
    }

    @Override
    public boolean isEqual(Byte x, Byte y) throws HibernateException {
        return StandardSpiBasicTypes.BYTE.areEqual(x, y);
    }
}

