/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Map;
import javax.persistence.metamodel.Type;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.produce.spi.TableReferenceContributor;

public interface CollectionElement<J>
extends Navigable<J>,
CollectionDomainType.Element<J>,
TableReferenceContributor {
    public static final String NAVIGABLE_NAME = "{element}";

    public boolean canContainSubGraphs();

    public ElementClassification getClassification();

    public PersistentCollectionDescriptor getCollectionDescriptor();

    public Table getPrimaryDmlTable();

    public SimpleTypeDescriptor getDomainTypeDescriptor();

    @Override
    default public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    public boolean hasNotNullColumns();

    public boolean isMutable();

    default public J replace(J originalValue, J targetValue, Object owner, Map copyCache, SessionImplementor session) {
        return (J)this.getJavaTypeDescriptor().getMutabilityPlan().replace(this, originalValue, targetValue, owner, copyCache, session);
    }

    public static enum ElementClassification {
        BASIC(Type.PersistenceType.BASIC),
        EMBEDDABLE(Type.PersistenceType.EMBEDDABLE),
        ANY(null),
        ONE_TO_MANY(Type.PersistenceType.ENTITY),
        MANY_TO_MANY(Type.PersistenceType.ENTITY);

        private final Type.PersistenceType correspondingJpaPersistenceType;

        private ElementClassification(Type.PersistenceType correspondingJpaPersistenceType) {
            this.correspondingJpaPersistenceType = correspondingJpaPersistenceType;
        }

        public Type.PersistenceType getCorrespondingJpaPersistenceType() {
            return this.correspondingJpaPersistenceType;
        }
    }
}

