/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import javax.persistence.metamodel.Type;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.BasicValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.internal.ColumnBasedMapper;

public class CollectionIdentifier
implements BasicValuedNavigable<Object> {
    public static final String NAVIGABLE_NAME = "{collection-id}";
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final Column column;
    private final BasicValueMapper valueMapper;
    private final IdentifierGenerator generator;
    private final NavigableRole navigableRole;

    public <O, C, E> CollectionIdentifier(PersistentCollectionDescriptor<O, C, E> collectionDescriptor, Column column, IdentifierGenerator generator) {
        this.collectionDescriptor = collectionDescriptor;
        this.column = column;
        this.valueMapper = new ColumnBasedMapper(column);
        this.generator = generator;
        this.navigableRole = collectionDescriptor.getNavigableRole().append(NAVIGABLE_NAME);
    }

    public IdentifierGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public NavigableContainer<?> getContainer() {
        return this.collectionDescriptor;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        visitor.visitCollectionIdentifier(this);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        return new BasicResultImpl(resultVariable, sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(creationState.getFromClauseAccess().getTableGroup(navigablePath.getParent()), this.column), this.column.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.column.getExpressableType());
    }

    @Override
    public String asLoggableText() {
        return this.navigableRole.getFullPath();
    }

    @Override
    public BasicJavaDescriptor<Object> getJavaTypeDescriptor() {
        return this.column.getJavaTypeDescriptor();
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<Object> getValueMapper() {
        return this.valueMapper;
    }
}

