/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.metamodel.Type;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.internal.ForeignKeyDomainResult;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.AbstractPersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sql.internal.ResolvedScalarDomainResult;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.results.internal.domain.embedded.CompositeForeignKeyResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionKey<T>
implements Navigable<T> {
    private final AbstractPersistentCollectionDescriptor collectionDescriptor;
    private final JavaTypeDescriptor javaTypeDescriptor;
    private final NavigableRole navigableRole;
    private final ForeignKey joinForeignKey;
    private Navigable foreignKeyTargetNavigable;

    public CollectionKey(AbstractPersistentCollectionDescriptor<?, ?, ?> runtimeDescriptor, Collection bootDescriptor, RuntimeModelCreationContext creationContext) {
        this.collectionDescriptor = runtimeDescriptor;
        this.javaTypeDescriptor = CollectionKey.resolveJavaTypeDescriptor(bootDescriptor);
        this.navigableRole = runtimeDescriptor.getNavigableRole().append("{collection-key}");
        this.joinForeignKey = creationContext.getDatabaseObjectResolver().resolveForeignKey(bootDescriptor.getForeignKey());
    }

    public ForeignKey getJoinForeignKey() {
        return this.joinForeignKey;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public Navigable getForeignKeyTargetNavigable() {
        if (this.foreignKeyTargetNavigable == null) {
            this.createForeignKeyTargetNavigable();
        }
        return this.foreignKeyTargetNavigable;
    }

    public DomainResult createContainerResult(ColumnReferenceQualifier containerReferenceQualifier, DomainResultCreationState creationState) {
        assert (containerReferenceQualifier != null);
        return this.createDomainResult(this.joinForeignKey.getColumnMappings().getTargetColumns(), containerReferenceQualifier, creationState);
    }

    void createForeignKeyTargetNavigable() {
        this.foreignKeyTargetNavigable = !StringHelper.isEmpty(this.collectionDescriptor.getMappedByProperty()) && this.collectionDescriptor.isOneToMany() ? ((NavigableContainer)((Object)this.collectionDescriptor.getElementDescriptor())).findNavigable(this.collectionDescriptor.getMappedByProperty()) : this.collectionDescriptor.findEntityOwnerDescriptor().getIdentifierDescriptor();
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        NavigablePath tableGroupPath = navigablePath.getParent() == null ? navigablePath : navigablePath.getParent();
        return this.createCollectionResult(creationState.getFromClauseAccess().getTableGroup(tableGroupPath), creationState);
    }

    private DomainResult createDomainResult(List<Column> columns, ColumnReferenceQualifier referenceQualifier, DomainResultCreationState creationState) {
        if (columns.size() == 1) {
            return new ResolvedScalarDomainResult(this.resolveSqlSelection(referenceQualifier, columns.get(0), creationState.getSqlAstCreationState()), null, columns.get(0).getJavaTypeDescriptor());
        }
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>();
        for (Column column : columns) {
            sqlSelections.add(this.resolveSqlSelection(referenceQualifier, column, creationState.getSqlAstCreationState()));
        }
        if (this.getForeignKeyTargetNavigable() instanceof EmbeddedValuedNavigable) {
            return new CompositeForeignKeyResultImpl(((EmbeddedValuedNavigable)this.getForeignKeyTargetNavigable()).getEmbeddedDescriptor(), sqlSelections);
        }
        return new ForeignKeyDomainResult(this.getJavaTypeDescriptor(), sqlSelections);
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    private SqlSelection resolveSqlSelection(ColumnReferenceQualifier referenceQualifier, Column column, SqlAstCreationState creationState) {
        return creationState.getSqlExpressionResolver().resolveSqlSelection(creationState.getSqlExpressionResolver().resolveSqlExpression(referenceQualifier, column), column.getJavaTypeDescriptor(), creationState.getCreationContext().getDomainModel().getTypeConfiguration());
    }

    public DomainResult createCollectionResult(ColumnReferenceQualifier referenceQualifier, DomainResultCreationState creationState) {
        return this.createDomainResult(this.joinForeignKey.getColumnMappings().getReferringColumns(), referenceQualifier, creationState);
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        for (Column column : this.getJoinForeignKey().getColumnMappings().getReferringColumns()) {
            action.accept(column.getExpressableType(), column);
        }
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        for (Column column : this.getJoinForeignKey().getColumnMappings().getReferringColumns()) {
            action.accept(column.getExpressableType());
        }
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        if (this.getForeignKeyTargetNavigable() instanceof SingularPersistentAttributeEntity) {
            return ((SingularPersistentAttributeEntity)this.getForeignKeyTargetNavigable()).getEntityDescriptor().getIdentifierDescriptor().unresolve(value, session);
        }
        return this.getForeignKeyTargetNavigable().unresolve(value, session);
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        List<Column> referringColumns = this.getJoinForeignKey().getColumnMappings().getReferringColumns();
        AtomicInteger position = new AtomicInteger();
        this.getForeignKeyTargetNavigable().dehydrate(value, (jdbcValue, type, boundColumn) -> {
            Column fkColumn = (Column)referringColumns.get(position.getAndIncrement());
            jdbcValueCollector.collect(jdbcValue, type, fkColumn);
        }, clause, session);
    }

    private static JavaTypeDescriptor resolveJavaTypeDescriptor(Collection collectionValue) {
        if (collectionValue.getJavaTypeMapping() != null) {
            return collectionValue.getJavaTypeMapping().getJavaTypeDescriptor();
        }
        return null;
    }

    @Override
    public NavigableContainer<?> getContainer() {
        return this.collectionDescriptor;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        visitor.visitCollectionForeignKey(this);
    }

    @Override
    public String asLoggableText() {
        return "CollectionKey(" + this.collectionDescriptor.getNavigableRole().getFullPath() + ")";
    }

    public Type.PersistenceType getPersistenceType() {
        return null;
    }

    @Override
    public boolean areEqual(T x, T y) throws HibernateException {
        return this.getForeignKeyTargetNavigable().areEqual(x, y);
    }

    @Override
    public int extractHashCode(T o) {
        return this.getForeignKeyTargetNavigable().extractHashCode(o);
    }
}

