/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.StringTokenizer;
import org.hibernate.FetchMode;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.jboss.logging.Logger;

public class DomainModelHelper {
    private static final Logger log = Logger.getLogger(DomainModelHelper.class);

    public static <T, S extends T> ManagedTypeDescriptor<S> resolveSubType(ManagedTypeDescriptor<T> baseType, String subTypeName, SessionFactoryImplementor sessionFactory) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        if (baseType instanceof EmbeddedTypeDescriptor) {
            return baseType;
        }
        String importedClassName = metamodel.getImportedName(subTypeName);
        if (importedClassName != null) {
            EntityDomainType subManagedType = metamodel.entity(importedClassName);
            if (subManagedType != null) {
                return subManagedType;
            }
            try {
                Class subTypeClass = sessionFactory.getServiceRegistry().getService(ClassLoaderService.class).classForName(importedClassName);
                return metamodel.managedType(subTypeClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Unknown sub-type name (" + baseType.getDomainTypeName() + ") : " + subTypeName);
    }

    public static <S> ManagedTypeDescriptor<S> resolveSubType(ManagedTypeDescriptor<? super S> baseType, Class<S> subTypeClass, SessionFactoryImplementor sessionFactory) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        return metamodel.managedType(subTypeClass);
    }

    public static FetchStrategy determineFetchStrategy(PersistentAttributeMapping bootModelAttribute, ManagedTypeDescriptor runtimeModelContainer, EntityTypeDescriptor entityDescriptor) {
        FetchStyle style = DomainModelHelper.determineStyle(bootModelAttribute, entityDescriptor);
        return new FetchStrategy(DomainModelHelper.determineTiming(style, runtimeModelContainer), style);
    }

    private static FetchTiming determineTiming(FetchStyle style, ManagedTypeDescriptor runtimeModelContainer) {
        switch (style) {
            case JOIN: {
                return FetchTiming.IMMEDIATE;
            }
            case BATCH: 
            case SUBSELECT: {
                return FetchTiming.DELAYED;
            }
        }
        if (runtimeModelContainer instanceof EntityTypeDescriptor) {
            EntityTypeDescriptor container = (EntityTypeDescriptor)runtimeModelContainer;
            if (!container.hasProxy() && !container.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                return FetchTiming.IMMEDIATE;
            }
            return FetchTiming.DELAYED;
        }
        return FetchTiming.DELAYED;
    }

    private static FetchStyle determineStyle(PersistentAttributeMapping bootModelAttribute, EntityTypeDescriptor entityDescriptor) {
        FetchMode fetchMode = bootModelAttribute.getValueMapping().getFetchMode();
        switch (fetchMode) {
            case JOIN: {
                if (bootModelAttribute.isLazy()) {
                    log.debugf("%s.%s defined join fetch and lazy", (Object)bootModelAttribute.getEntity().getEntityName(), (Object)bootModelAttribute.getName());
                }
                return FetchStyle.JOIN;
            }
        }
        return FetchStyle.SELECT;
    }

    public static FetchStrategy determineFetchStrategy(Collection bootCollectionDescriptor) {
        FetchStyle style = DomainModelHelper.determineStyle(bootCollectionDescriptor);
        return new FetchStrategy(DomainModelHelper.determineTiming(bootCollectionDescriptor, style), style);
    }

    private static FetchTiming determineTiming(Collection bootCollectionDescriptor, FetchStyle style) {
        switch (style) {
            case JOIN: {
                return FetchTiming.IMMEDIATE;
            }
            case BATCH: 
            case SUBSELECT: {
                return FetchTiming.DELAYED;
            }
        }
        return bootCollectionDescriptor.isLazy() || bootCollectionDescriptor.isExtraLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
    }

    private static FetchStyle determineStyle(Collection bootCollectionDescriptor) {
        if (bootCollectionDescriptor.getBatchSize() > 1) {
            return FetchStyle.BATCH;
        }
        if (bootCollectionDescriptor.isSubselectLoadable()) {
            return FetchStyle.SUBSELECT;
        }
        FetchMode fetchMode = bootCollectionDescriptor.getFetchMode();
        if (fetchMode == FetchMode.JOIN) {
            return FetchStyle.JOIN;
        }
        return FetchStyle.SELECT;
    }

    public static CascadeStyle determineCascadeStyle(String cascade) {
        if (cascade == null || cascade.equals("none")) {
            return CascadeStyles.NONE;
        }
        StringTokenizer tokens = new StringTokenizer(cascade, ", ");
        CascadeStyle[] styles = new CascadeStyle[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            styles[i++] = CascadeStyles.getCascadeStyle(tokens.nextToken());
        }
        return new CascadeStyles.MultipleCascadeStyle(styles);
    }
}

