/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.TreatAsHelper;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.sql.ast.produce.metamodel.spi.EmbeddedValueExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.results.internal.domain.embedded.CompositeResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;

public interface EmbeddedValuedNavigable<J>
extends EmbeddedValueExpressableType<J>,
Joinable<J> {
    public EmbeddedContainer getContainer();

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor();

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor();

    default public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    default public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        return new SqmEmbeddedValuedSimplePath(lhs.getNavigablePath().append(this.getNavigableName()), this, lhs);
    }

    @Override
    default public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        creationState.getFromClauseAccess().resolveTableGroup(navigablePath, np -> creationState.getFromClauseAccess().getTableGroup(navigablePath.getParent()));
        return new CompositeResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    default public int getNumberOfJdbcParametersNeeded() {
        return this.getEmbeddedDescriptor().getNumberOfJdbcParametersNeeded();
    }

    @Override
    default public SqmNavigableJoin createJoin(SqmFrom lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        return this.getEmbeddedDescriptor().createJoin(lhs, joinType, alias, fetched, creationState);
    }

    @Override
    default public <X> X as(Class<X> type) {
        return TreatAsHelper.handleEmbeddedTreat(this, type);
    }
}

