/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.InheritanceStrategy;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.RowIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.type.descriptor.java.spi.EntityMutabilityPlan;

public interface EntityHierarchy {
    public RepresentationMode getRepresentation();

    public InheritanceStrategy getInheritanceStrategy();

    public <J> EntityTypeDescriptor<J> getRootEntityType();

    public <O, J> EntityIdentifier<O, J> getIdentifierDescriptor();

    public NaturalIdDescriptor getNaturalIdDescriptor();

    public <J> DiscriminatorDescriptor<J> getDiscriminatorDescriptor();

    public <O, J> VersionDescriptor<O, J> getVersionDescriptor();

    public OptimisticLockStyle getOptimisticLockStyle();

    public <J> RowIdDescriptor<J> getRowIdDescriptor();

    public TenantDiscrimination getTenantDiscrimination();

    public EntityDataAccess getEntityCacheAccess();

    public SqmMutationStrategy getSqmMutationStrategy();

    public String getWhere();

    public EntityMutabilityPlan getMutabilityPlan();

    public boolean isImplicitPolymorphismEnabled();

    public void finishInitialization(RuntimeModelCreationContext var1, RootClass var2);

    default public Navigable findNavigable(String navigableName) {
        if (this.getIdentifierDescriptor().matchesNavigableName(navigableName)) {
            return this.getIdentifierDescriptor();
        }
        if (this.getDiscriminatorDescriptor() != null && this.getDiscriminatorDescriptor().matchesNavigableName(navigableName)) {
            return this.getDiscriminatorDescriptor();
        }
        if (this.getRowIdDescriptor() != null && this.getRowIdDescriptor().matchesNavigableName(navigableName)) {
            return this.getRowIdDescriptor();
        }
        return null;
    }

    public void visitConstraintOrderedTables(BiConsumer<Table, List<Column>> var1);
}

