/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metamodel.model.domain.spi.AllowableOutputParameterType;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.exec.spi.ExecutionContext;

public interface EntityIdentifier<O, J>
extends Navigable<J>,
AllowableOutputParameterType<J> {
    public static final String NAVIGABLE_ID = "{id}";
    public static final String LEGACY_NAVIGABLE_ID = "id";

    @Override
    public SimpleTypeDescriptor<J> getNavigableType();

    default public boolean hasSingleIdAttribute() {
        return this instanceof SingularPersistentAttribute;
    }

    default public <E extends O> J extractIdentifier(E entityInstance) {
        return (J)this.asAttribute(this.getJavaType()).getPropertyAccess().getGetter().get(entityInstance);
    }

    default public void injectIdentifier(J entity, J id, SharedSessionContractImplementor session) {
        this.asAttribute(this.getJavaType()).getPropertyAccess().getSetter().set(entity, id, session.getFactory());
    }

    public <T> SingularPersistentAttribute<O, T> asAttribute(Class<T> var1);

    public IdentifierGenerator getIdentifierValueGenerator();

    default public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public List<Column> getColumns();

    @Override
    default public int getNumberOfJdbcParametersNeeded() {
        return this.getColumns().size();
    }

    @Override
    default public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationState) {
        ArrayList<ColumnReference> columnRefs = new ArrayList<ColumnReference>();
        for (Column column : this.getColumns()) {
            Expression expression = creationState.getSqlExpressionResolver().resolveSqlExpression(qualifier, column);
            if (!ColumnReference.class.isInstance(expression)) {
                columnRefs.add((ColumnReference)((SqlSelectionExpression)expression).getExpression());
                continue;
            }
            columnRefs.add((ColumnReference)expression);
        }
        return columnRefs;
    }

    public boolean matchesNavigableName(String var1);

    public boolean canContainSubGraphs();

    public IdentifierValue getUnsavedValue();
}

