/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.InheritanceCapable;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.JoinedTableBinding;
import org.hibernate.metamodel.model.relational.spi.Table;

public interface IdentifiableTypeDescriptor<T>
extends InheritanceCapable<T>,
IdentifiableDomainType<T> {
    default public IdentifiableTypeDescriptor<? super T> getSupertype() {
        return this.getSuperclassType();
    }

    @Override
    public IdentifiableTypeDescriptor<? super T> getSuperclassType();

    public SimpleTypeDescriptor<?> getIdType();

    public EntityHierarchy getHierarchy();

    @Override
    public InFlightAccess<T> getInFlightAccess();

    public void visitSubTypeDescriptors(Consumer<IdentifiableTypeDescriptor<? extends T>> var1);

    public void visitAllSubTypeDescriptors(Consumer<IdentifiableTypeDescriptor<? extends T>> var1);

    public IdentifiableTypeDescriptor findMatchingSubTypeDescriptors(Predicate<IdentifiableTypeDescriptor<? extends T>> var1);

    default public void visitConstraintOrderedTables(BiConsumer<Table, List<Column>> tableConsumer) {
        for (JoinedTableBinding secondaryTableBinding : this.getSecondaryTableBindings()) {
            tableConsumer.accept(secondaryTableBinding.getReferringTable(), secondaryTableBinding.getJoinForeignKey().getColumnMappings().getReferringColumns());
        }
        Table primaryTable = this.getPrimaryTable();
        if (primaryTable != null) {
            tableConsumer.accept(primaryTable, primaryTable.getPrimaryKey().getColumns());
        }
    }

    default public Table getPrimaryTable() {
        return null;
    }

    default public List<JoinedTableBinding> getSecondaryTableBindings() {
        return Collections.emptyList();
    }

    public static interface InFlightAccess<X>
    extends ManagedTypeDescriptor.InFlightAccess<X> {
        public void addSubTypeDescriptor(IdentifiableTypeDescriptor var1);
    }
}

