/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.time.Instant;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class InstantVersionSupport
implements VersionSupport<Instant> {
    public static final InstantVersionSupport INSTANCE = new InstantVersionSupport();

    @Override
    public Instant seed(SharedSessionContractImplementor session) {
        return Instant.now();
    }

    @Override
    public Instant next(Instant current, SharedSessionContractImplementor session) {
        return Instant.now();
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.INSTANT.toLoggableString(value);
    }

    @Override
    public boolean isEqual(Instant x, Instant y) throws HibernateException {
        return StandardSpiBasicTypes.INSTANT.areEqual(x, y);
    }
}

