/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class IntegerVersionSupport
implements VersionSupport<Integer> {
    public static final IntegerVersionSupport INSTANCE = new IntegerVersionSupport();
    public static final Integer ZERO = 0;

    @Override
    public Integer seed(SharedSessionContractImplementor session) {
        return ZERO;
    }

    @Override
    public Integer next(Integer current, SharedSessionContractImplementor session) {
        return current + 1;
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.INTEGER.toLoggableString(value);
    }

    @Override
    public boolean isEqual(Integer x, Integer y) throws HibernateException {
        return StandardSpiBasicTypes.INTEGER.areEqual(x, y);
    }
}

