/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.time.LocalDateTime;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class LocalDateTimeVersionSupport
implements VersionSupport<LocalDateTime> {
    public static final LocalDateTimeVersionSupport INSTANCE = new LocalDateTimeVersionSupport();

    @Override
    public LocalDateTime seed(SharedSessionContractImplementor session) {
        return LocalDateTime.now();
    }

    @Override
    public LocalDateTime next(LocalDateTime current, SharedSessionContractImplementor session) {
        return LocalDateTime.now();
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.LOCAL_DATE_TIME.toLoggableString(value);
    }

    @Override
    public boolean isEqual(LocalDateTime x, LocalDateTime y) throws HibernateException {
        return StandardSpiBasicTypes.LOCAL_DATE_TIME.areEqual(x, y);
    }
}

