/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class LongVersionSupport
implements VersionSupport<Long> {
    public static final LongVersionSupport INSTANCE = new LongVersionSupport();
    private static final Long ZERO = 0L;

    @Override
    public Long seed(SharedSessionContractImplementor session) {
        return ZERO;
    }

    @Override
    public Long next(Long current, SharedSessionContractImplementor session) {
        return current + 1L;
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.LONG.toLoggableString(value);
    }

    @Override
    public boolean isEqual(Long x, Long y) throws HibernateException {
        return StandardSpiBasicTypes.LONG.areEqual(x, y);
    }
}

