/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.persistence.metamodel.CollectionAttribute;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.annotations.Remove;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributorContainer;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.ManagedJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public interface ManagedTypeDescriptor<T>
extends ManagedDomainType<T>,
SimpleTypeDescriptor<T>,
NavigableContainer<T>,
EmbeddedContainer<T>,
ExpressableType<T>,
StateArrayContributorContainer {
    public boolean finishInitialization(ManagedTypeMappingImplementor var1, RuntimeModelCreationContext var2);

    default public void postInitialization(RuntimeModelCreationContext creationContext) {
    }

    public TypeConfiguration getTypeConfiguration();

    @Override
    public ManagedJavaDescriptor<T> getJavaTypeDescriptor();

    default public String getDomainTypeName() {
        return this.getJavaTypeDescriptor().getTypeName();
    }

    public ManagedTypeRepresentationStrategy getRepresentationStrategy();

    public NonIdPersistentAttribute<? super T, ?> findPersistentAttribute(String var1);

    public NonIdPersistentAttribute<? super T, ?> findDeclaredPersistentAttribute(String var1);

    default public <R> NonIdPersistentAttribute<? super T, R> findDeclaredPersistentAttribute(String name, Class<R> resultType) {
        return this.findDeclaredPersistentAttribute(name);
    }

    public List<NonIdPersistentAttribute> getPersistentAttributes();

    public List<NonIdPersistentAttribute> getDeclaredPersistentAttributes();

    default public void controlledVisitAttributes(Function<NonIdPersistentAttribute, Boolean> action) {
        NonIdPersistentAttribute attribute;
        Boolean keepGoing;
        Iterator<NonIdPersistentAttribute> iterator = this.getPersistentAttributes().iterator();
        while (iterator.hasNext() && (keepGoing = action.apply(attribute = iterator.next())).booleanValue()) {
        }
    }

    default public <O, J> void visitAttributes(Consumer<PersistentAttributeDescriptor<O, J>> action, Predicate<PersistentAttributeDescriptor<O, J>> filter) {
        this.visitAttributes(attribute -> {
            if (filter.test((PersistentAttributeDescriptor)attribute)) {
                action.accept((PersistentAttributeDescriptor)attribute);
            }
        });
    }

    default public void visitAttributes(Consumer<NonIdPersistentAttribute> consumer) {
        for (NonIdPersistentAttribute attribute : this.getPersistentAttributes()) {
            consumer.accept(attribute);
        }
    }

    default public boolean hasMutableProperties() {
        throw new NotYetImplementedFor6Exception();
    }

    default public void setPropertyValues(Object object, Object[] values) {
        this.visitStateArrayContributors(contributor -> {
            Object value = values[contributor.getStateArrayPosition()];
            contributor.getPropertyAccess().getSetter().set(object, value, this.getTypeConfiguration().getSessionFactory());
        });
    }

    default public Object[] getPropertyValues(Object object) {
        Object[] values = new Object[this.getStateArrayContributors().size()];
        if (object != null && object != PropertyAccessStrategyBackRefImpl.UNKNOWN) {
            this.visitStateArrayContributors(contributor -> {
                values[contributor.getStateArrayPosition()] = contributor.getPropertyAccess().getGetter().get(object);
            });
        }
        return values;
    }

    @Deprecated
    @Remove
    default public void setPropertyValue(Object object, int i, Object value) {
        throw new NotYetImplementedFor6Exception();
    }

    @Deprecated
    @Remove
    default public Object getPropertyValue(Object object, int i) throws HibernateException {
        return ((StateArrayContributor)this.getStateArrayContributors().get(i)).getPropertyAccess().getGetter().get(object);
    }

    @Deprecated
    @Remove
    default public Object getPropertyValue(Object object, String propertyName) {
        return this.findPersistentAttribute(propertyName).getPropertyAccess().getGetter().get(object);
    }

    public SubGraphImplementor<T> makeSubGraph();

    default public SubGraphImplementor<T> getDefaultGraph() {
        throw new UnsupportedOperationException("Not yet implemented - " + this.getClass().getName());
    }

    public <S extends T> SubGraphImplementor<S> makeSubGraph(Class<S> var1);

    public <S extends T> ManagedTypeDescriptor<S> findSubType(String var1);

    public <S extends T> ManagedTypeDescriptor<S> findSubType(Class<S> var1);

    public InFlightAccess<T> getInFlightAccess();

    @Override
    public PersistentAttributeDescriptor<? super T, ?> getAttribute(String var1);

    @Override
    public PersistentAttributeDescriptor<T, ?> getDeclaredAttribute(String var1);

    public CollectionAttribute<? super T, ?> getCollection(String var1);

    public <E> CollectionAttribute<? super T, E> getCollection(String var1, Class<E> var2);

    public CollectionAttribute<T, ?> getDeclaredCollection(String var1);

    public static interface InFlightAccess<T> {
        public void addAttribute(PersistentAttributeDescriptor<T, ?> var1);

        public void finishUp();
    }
}

