/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;

public interface NaturalIdDescriptor<J>
extends Navigable<J> {
    default public void visitPersistentAttributes(Consumer<NaturalIdAttributeInfo> action) {
        this.getAttributeInfos().forEach(action);
    }

    public List<NaturalIdAttributeInfo> getAttributeInfos();

    default public List<NonIdPersistentAttribute> getPersistentAttributes() {
        return this.getAttributeInfos().stream().map(info -> info.getUnderlyingAttributeDescriptor()).collect(Collectors.toList());
    }

    public boolean isMutable();

    public Object[] resolveSnapshot(Object var1, SharedSessionContractImplementor var2);

    public NaturalIdDataAccess getCacheAccess();

    public static interface NaturalIdAttributeInfo {
        public NonIdPersistentAttribute getUnderlyingAttributeDescriptor();

        public int getStateArrayPosition();
    }
}

