/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.DomainTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.spi.TypeConfiguration;

public interface Navigable<T>
extends DomainTypeDescriptor<T> {
    public NavigableContainer<?> getContainer();

    default public EntityTypeDescriptor findFirstEntityDescriptor() {
        if (this instanceof EntityValuedNavigable) {
            return ((EntityValuedNavigable)this).getEntityDescriptor();
        }
        NavigableContainer<?> container = this.getContainer();
        if (container != null) {
            return container.findFirstEntityDescriptor();
        }
        throw new IllegalStateException("Could not locate first entity descriptor");
    }

    public NavigableRole getNavigableRole();

    default public String getNavigableName() {
        return this.getNavigableRole().getNavigableName();
    }

    default public DomainTypeDescriptor<T> getNavigableType() {
        return this;
    }

    public void visitNavigable(NavigableVisitationStrategy var1);

    default public boolean finishInitialization(Object bootReference, RuntimeModelCreationContext creationContext) {
        return true;
    }

    public SqmNavigableReference createSqmExpression(SqmPath var1, SqmCreationState var2);

    default public DomainResult createDomainResult(NavigablePath navigablePath, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public String asLoggableText();

    default public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public <X> X as(Class<X> type) {
        if (type.isInstance(this)) {
            return (X)this;
        }
        throw new UnsupportedOperationException(String.format(Locale.ROOT, "`%s` cannot be treated as `%s`", this.getClass().getName(), type.getName()));
    }
}

