/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeBasic;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.BasicCollectionElement;
import org.hibernate.metamodel.model.domain.spi.BasicCollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEmbedded;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEntity;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEmbedded;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEntity;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierCompositeAggregated;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierCompositeNonAggregated;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierSimple;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.RowIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;

public interface NavigableVisitationStrategy {
    default public void prepareForVisitation() {
    }

    default public void visitationComplete() {
    }

    default public void visitEntity(EntityTypeDescriptor entity) {
    }

    default public void visitSimpleIdentifier(EntityIdentifierSimple identifier) {
    }

    default public void visitAggregateCompositeIdentifier(EntityIdentifierCompositeAggregated identifier) {
    }

    default public void visitNonAggregateCompositeIdentifier(EntityIdentifierCompositeNonAggregated identifier) {
    }

    default public void visitDiscriminator(DiscriminatorDescriptor discriminator) {
    }

    default public void visitTenantTenantDiscrimination(TenantDiscrimination tenantDiscrimination) {
    }

    default public void visitVersion(VersionDescriptor version) {
    }

    default public void visitRowIdDescriptor(RowIdDescriptor rowIdDescriptor) {
    }

    default public void visitSingularAttributeBasic(SingularPersistentAttributeBasic attribute) {
    }

    default public void visitSingularAttributeEmbedded(SingularPersistentAttributeEmbedded attribute) {
    }

    default public void visitSingularAttributeEntity(SingularPersistentAttributeEntity attribute) {
    }

    default public void visitPluralAttribute(PluralPersistentAttribute attribute) {
        CollectionIndex indexDescriptor;
        this.visitCollectionForeignKey(attribute.getPersistentCollectionDescriptor().getCollectionKeyDescriptor());
        CollectionIdentifier idDescriptor = attribute.getPersistentCollectionDescriptor().getIdDescriptor();
        if (idDescriptor != null) {
            this.visitCollectionIdentifier(idDescriptor);
        }
        if ((indexDescriptor = attribute.getPersistentCollectionDescriptor().getIndexDescriptor()) != null) {
            indexDescriptor.visitNavigable(this);
        }
        attribute.getPersistentCollectionDescriptor().getElementDescriptor().visitNavigable(this);
    }

    default public void visitCollectionForeignKey(CollectionKey collectionKey) {
    }

    default public void visitCollectionIdentifier(CollectionIdentifier identifier) {
    }

    default public void visitCollectionElementBasic(BasicCollectionElement element) {
    }

    default public void visitCollectionElementEmbedded(CollectionElementEmbedded element) {
    }

    default public void visitCollectionElementEntity(CollectionElementEntity element) {
    }

    default public void visitCollectionIndexBasic(BasicCollectionIndex index) {
    }

    default public void visitCollectionIndexEmbedded(CollectionIndexEmbedded index) {
    }

    default public void visitCollectionIndexEntity(CollectionIndexEntity index) {
    }
}

