/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.metamodel.Type;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.loader.spi.CollectionLoader;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.CollectionMutabilityPlan;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Filterable;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.spi.RootTableGroupProducer;
import org.hibernate.sql.ast.produce.spi.TableGroupJoinProducer;
import org.hibernate.sql.ast.produce.spi.TableReferenceContributor;
import org.hibernate.type.descriptor.java.internal.CollectionJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public interface PersistentCollectionDescriptor<O, C, E>
extends CollectionDomainType<C, E>,
PluralValuedNavigable<C>,
RootTableGroupProducer,
TableGroupJoinProducer,
TableReferenceContributor,
EmbeddedContainer<C>,
Filterable,
Joinable<C>,
Fetchable<C> {
    public static final Object UNFETCHED_COLLECTION = new MarkerObject("UNFETCHED COLLECTION");
    public static final Class[] CONSTRUCTOR_SIGNATURE = new Class[]{Property.class, ManagedTypeDescriptor.class, RuntimeModelCreationContext.class};

    public boolean finishInitialization(org.hibernate.mapping.Collection var1, RuntimeModelCreationContext var2);

    default public CollectionClassification getCollectionClassification() {
        return this.getSemantics().getCollectionClassification();
    }

    public CollectionSemantics<C> getSemantics();

    @Override
    public CollectionJavaDescriptor<C> getJavaTypeDescriptor();

    @Override
    public ManagedTypeDescriptor<O> getContainer();

    @Override
    public NavigableRole getNavigableRole();

    public PluralPersistentAttribute getDescribedAttribute();

    public CollectionMutabilityPlan<C> getMutabilityPlan();

    public Navigable getForeignKeyTargetNavigable();

    public CollectionKey getCollectionKeyDescriptor();

    public CollectionIdentifier getIdDescriptor();

    @Override
    public CollectionElement<E> getElementDescriptor();

    public <I> CollectionIndex<I> getIndexDescriptor();

    default public Comparator<?> getSortingComparator() {
        return null;
    }

    @Override
    default public <N> Navigable<N> findNavigable(String navigableName) {
        if ("key".equals(navigableName) || "{key}".equals(navigableName) || "keys".equals(navigableName) || "{keys}".equals(navigableName) || "index".equals(navigableName) || "{index}".equals(navigableName) || "indices".equals(navigableName) || "{indices}".equals(navigableName)) {
            return this.getIndexDescriptor();
        }
        if ("element".equals(navigableName) || "{element}".equals(navigableName) || "elements".equals(navigableName) || "{elements}".equals(navigableName) || "value".equals(navigableName) || "{value}".equals(navigableName) || "values".equals(navigableName) || "{values}".equals(navigableName)) {
            return this.getElementDescriptor();
        }
        CollectionDomainType.Element elementDescriptor = this.getElementDescriptor();
        if (elementDescriptor instanceof NavigableContainer) {
            return ((NavigableContainer)((Object)this.getElementDescriptor())).findNavigable(navigableName);
        }
        return null;
    }

    @Override
    default public void visitNavigables(NavigableVisitationStrategy visitor) {
        if (this.getIndexDescriptor() != null) {
            this.getIndexDescriptor().visitNavigable(visitor);
        }
        this.getElementDescriptor().visitNavigable(visitor);
    }

    @Override
    default public String getNavigableName() {
        return this.getNavigableRole().getNavigableName();
    }

    @Override
    default public void visitNavigable(NavigableVisitationStrategy visitor) {
        this.visitNavigables(visitor);
    }

    @Override
    default public boolean canCompositeContainCollections() {
        return false;
    }

    public CollectionLoader getLoader();

    public Table getSeparateCollectionTable();

    public Set<String> getCollectionSpaces();

    public boolean isInverse();

    public boolean hasOrphanDelete();

    public boolean isOneToMany();

    public boolean isExtraLazy();

    @Override
    public boolean isDirty(Object var1, Object var2, SharedSessionContractImplementor var3);

    public int getSize(Object var1, SharedSessionContractImplementor var2);

    public Boolean indexExists(Object var1, Object var2, SharedSessionContractImplementor var3);

    public Boolean elementExists(Object var1, Object var2, PersistentCollection var3, SharedSessionContractImplementor var4);

    public Object getElementByIndex(Object var1, Object var2, SharedSessionContractImplementor var3, Object var4);

    default public Type.PersistenceType getPersistenceType() {
        switch (this.getElementDescriptor().getClassification()) {
            case BASIC: {
                return Type.PersistenceType.BASIC;
            }
            case EMBEDDABLE: {
                return Type.PersistenceType.EMBEDDABLE;
            }
            case MANY_TO_MANY: 
            case ONE_TO_MANY: {
                return Type.PersistenceType.ENTITY;
            }
            case ANY: {
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized collection element classification : " + (Object)((Object)this.getElementDescriptor().getClassification()));
    }

    public boolean useOwnerIndetifier();

    @Deprecated
    default public String getRoleName() {
        return this.getNavigableRole().getFullPath();
    }

    public CacheEntryStructure getCacheEntryStructure();

    default public JavaTypeDescriptor getKeyJavaTypeDescriptor() {
        return this.getIndexDescriptor() == null ? null : this.getIndexDescriptor().getJavaTypeDescriptor();
    }

    default public SimpleTypeDescriptor getKeyDomainTypeDescriptor() {
        return this.getIndexDescriptor() == null ? null : this.getIndexDescriptor().getDomainTypeDescriptor();
    }

    public void remove(Object var1, SharedSessionContractImplementor var2);

    public void recreate(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);

    public void deleteRows(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);

    public void updateRows(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);

    public void insertRows(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);

    public void processQueuedOps(PersistentCollection var1, Object var2, SharedSessionContractImplementor var3);

    default public boolean hasCache() {
        return this.getCacheAccess() != null;
    }

    public CollectionDataAccess getCacheAccess();

    public void initialize(Object var1, SharedSessionContractImplementor var2);

    public int getBatchSize();

    public EntityTypeDescriptor findEntityOwnerDescriptor();

    public String getMappedByProperty();

    public Object getKeyOfOwner(Object var1, SessionImplementor var2);

    default public Iterator getElementsIterator(Object collection, SharedSessionContractImplementor session) {
        return ((Collection)collection).iterator();
    }

    default public C instantiateRaw(int anticipatedSize) {
        return this.getSemantics().instantiateRaw(anticipatedSize, this);
    }

    default public PersistentCollection<E> instantiateWrapper(SharedSessionContractImplementor session, Object key) {
        return this.getSemantics().instantiateWrapper(key, this, session);
    }

    default public PersistentCollection<E> wrap(SharedSessionContractImplementor session, C rawCollection) {
        return this.getSemantics().wrap(rawCollection, this, session);
    }

    public boolean contains(Object var1, E var2);

    default public Object indexOf(Object collection, Object element) {
        throw new UnsupportedOperationException("Collection type does not support indexes");
    }

    public Class getElementClass();
}

