/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class ShortVersionSupport
implements VersionSupport<Short> {
    public static final ShortVersionSupport INSTANCE = new ShortVersionSupport();
    private static final Short ZERO = 0;

    @Override
    public Short seed(SharedSessionContractImplementor session) {
        return ZERO;
    }

    @Override
    public Short next(Short current, SharedSessionContractImplementor session) {
        return (short)(current + 1);
    }

    @Override
    public String toLoggableString(Object value) {
        return StandardSpiBasicTypes.SHORT.toLoggableString(value);
    }

    @Override
    public boolean isEqual(Short x, Short y) throws HibernateException {
        return StandardSpiBasicTypes.SHORT.areEqual(x, y);
    }
}

