/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.spi;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;

public class TreatAsHelper {
    public static <X> X handleEmbeddedTreat(EmbeddedValuedNavigable navigable, Class<X> targetType) {
        if (targetType.isInstance(navigable)) {
            return (X)navigable;
        }
        if (targetType.isInstance(navigable.getEmbeddedDescriptor())) {
            return (X)navigable.getEmbeddedDescriptor();
        }
        throw TreatAsHelper.badTreat(navigable, targetType);
    }

    public static <X> X handleEntityTreat(EntityValuedNavigable navigable, Class<X> targetType) {
        if (targetType.isInstance(navigable)) {
            return (X)navigable;
        }
        if (targetType.isInstance(navigable.getEntityDescriptor())) {
            return (X)navigable.getEntityDescriptor();
        }
        if (targetType.isAssignableFrom(EntityHierarchy.class)) {
            return (X)navigable.getEntityDescriptor().getHierarchy();
        }
        if (targetType.isAssignableFrom(EntityIdentifier.class)) {
            return (X)navigable.getEntityDescriptor().getIdentifierDescriptor();
        }
        if (targetType.isAssignableFrom(VersionDescriptor.class)) {
            return (X)navigable.getEntityDescriptor().getHierarchy().getVersionDescriptor();
        }
        if (targetType.isAssignableFrom(DiscriminatorDescriptor.class)) {
            return (X)navigable.getEntityDescriptor().getHierarchy().getDiscriminatorDescriptor();
        }
        if (targetType.isAssignableFrom(TenantDiscrimination.class)) {
            return (X)navigable.getEntityDescriptor().getHierarchy().getTenantDiscrimination();
        }
        throw TreatAsHelper.badTreat(navigable, targetType);
    }

    public static <X> X handlePluralTreat(PluralValuedNavigable navigable, Class<X> targetType) {
        if (targetType.isInstance(navigable)) {
            return (X)navigable;
        }
        if (targetType.isInstance(navigable.getCollectionDescriptor().getDescribedAttribute())) {
            return (X)navigable.getCollectionDescriptor().getDescribedAttribute();
        }
        if (targetType.isInstance(navigable.getCollectionDescriptor())) {
            return (X)navigable.getCollectionDescriptor();
        }
        if (targetType.isAssignableFrom(CollectionKey.class)) {
            return (X)navigable.getCollectionDescriptor().getCollectionKeyDescriptor();
        }
        if (targetType.isAssignableFrom(CollectionElement.class)) {
            return (X)navigable.getCollectionDescriptor().getElementDescriptor();
        }
        if (targetType.isAssignableFrom(CollectionIndex.class)) {
            return (X)navigable.getCollectionDescriptor().getIndexDescriptor();
        }
        if (targetType.isAssignableFrom(CollectionIdentifier.class)) {
            return (X)navigable.getCollectionDescriptor().getIdDescriptor();
        }
        throw TreatAsHelper.badTreat(navigable, targetType);
    }

    private static RuntimeException badTreat(Navigable navigable, Class targetType) {
        return new IllegalArgumentException(String.format(Locale.ROOT, "`%s` cannot be treated as `%s`", navigable.getClass().getName(), targetType.getName()));
    }

    private TreatAsHelper() {
    }
}

